package jp.sourceforge.freegantt.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import jp.sourceforge.freegantt.data.Project;

public class CalendarUtil {

	public static Calendar toDateCalendar(long millis) {
		Calendar cal = Calendar.getInstance();
		cal.setTimeInMillis(millis);
		return toDateCalendar(cal);
	}
	
	public static Calendar toDateCalendar(Calendar cal) {
		if (cal == null) return null;
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal;
	}
	
	public static Calendar get(int year, int month, int day) {
		Calendar cal = Calendar.getInstance();
		cal.set(year, month, day);
		return toDateCalendar(cal);
	}
	
	public static boolean dateEquals(Calendar lhs, Calendar rhs) {
		return lhs.get(Calendar.YEAR) == rhs.get(Calendar.YEAR) && 
				lhs.get(Calendar.MONTH) == rhs.get(Calendar.MONTH) && 
				lhs.get(Calendar.DAY_OF_MONTH) == rhs.get(Calendar.DAY_OF_MONTH);
	}
	
	public static Calendar parseDate(String str, Locale locale) {
		if (locale.getLanguage().equals(Locale.JAPANESE.getLanguage())) {
			try {
				SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd", locale);
				Date date = format.parse(str);
				return toDateCalendar(date.getTime());
			} catch (ParseException e) {
			}
			try {
				SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd", locale);
				Date date = format.parse(str);
				return toDateCalendar(date.getTime());
			} catch (ParseException e) {
			}
		} else {
			try {
				SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy", locale);
				Date date = format.parse(str);
				return toDateCalendar(date.getTime());
			} catch (ParseException e) {
			}
			try {
				SimpleDateFormat format = new SimpleDateFormat("ddMMyyyy", locale);
				Date date = format.parse(str);
				return toDateCalendar(date.getTime());
			} catch (ParseException e) {
			}
		}
	
		return null;
	}
	
	public static int subDate(Calendar lhs, Calendar rhs) {
		if (lhs == null || rhs == null) return 0;
		return (int)((lhs.getTimeInMillis() - rhs.getTimeInMillis()) / 86400000);
	}
	
	/**
	 * 休日を除いた日付間の差日数を求める
	 * @param project
	 * @param lhs
	 * @param rhs
	 * @return
	 */
	public static int subDateUsingHoliday(Project project, Calendar lhs, Calendar rhs) {
		Calendar to = (Calendar)lhs.clone();
		Calendar from = (Calendar)rhs.clone();
		int sub = 0;
		for (int i=0; i<365; i++) {
			if (subDate(to, from) <= 0) return sub;
			if (!project.isHoliday(from)) sub++;
			from.add(Calendar.DATE, 1);
		}
		return sub;
	}
}
