package jp.sourceforge.freegantt.data;

public class Column implements Cloneable {
	String key = "";
	int width = 0;
	
	public Column clone() {
		try {
			return (Column)super.clone();
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
	
	public Column() {
	}
	
	public Column(String key, int width) {
		this.key = key;
		this.width = width;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}
	
	public boolean equals(Column target) {
		if (target == null) return false;
		return key.endsWith(target.key) && width == target.width;
	}
}
