package jp.sourceforge.freegantt.data.model;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.freegantt.data.Project;

public class ProjectModifiedModel {

	List<ProjectModifiedListener> listeners = new ArrayList<ProjectModifiedListener>();
	
	Project project;
	
	public ProjectModifiedModel(Project project) {
		this.project = project;
	}
	
	public void addProjectModifiedListener(ProjectModifiedListener l) {
		listeners.add(l);
	}
	
	public void removeProjectModifiedListener(ProjectModifiedListener l) {
		listeners.remove(l);
	}
	
	public void fireProjectModifiedEment() {
		for (ProjectModifiedListener listener: listeners) {
			listener.projectModified();
		}
	}
}
