package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;
import jp.sourceforge.freegantt.data.Task;

public class CreateTaskEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = 8645088149392022926L;

	Project project;
	Task newTask;
	
	public CreateTaskEdit(Project project, Task newTask) {
		this.project = project;

		this.newTask = newTask.clone();
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getTasks().remove(project.getTasks().size() - 1);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getTasks().add(newTask);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		newTask = null;
	}

}
