package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateFixedHolidayEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = -7576659663670592260L;
	
	Project project;
	int week;
	boolean value;
	
	public UpdateFixedHolidayEdit(Project project, int week, boolean value) {
		this.project = project;
		this.week = week;
		this.value = value;
	}
	
	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setFixedHoliday(week, !value);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setFixedHoliday(week, value);
	}

	@Override
	public void die() {
		project = null;
		super.die();
	}
}
