package jp.sourceforge.freegantt.data.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import jp.sourceforge.freegantt.data.Project;

public class UpdateProjectNameEdit extends AbstractUndoableEdit {
	private static final long serialVersionUID = -5451951385377166568L;

	Project project;
	String oldText;
	String newText;
	
	public UpdateProjectNameEdit(Project project, String text) {
		this.project = project;
		this.oldText = project.getName().toString();
		this.newText = text.toString();
	}

	@Override
	public void undo() throws CannotUndoException {
		System.out.println("Undo " + getClass().toString());
		super.undo();
		project.getController().setName(oldText);
	}

	@Override
	public void redo() throws CannotRedoException {
		super.redo();
		project.getController().setName(newText);
	}

	@Override
	public void die() {
		super.die();
		project = null;
		oldText = null;
		newText = null;
	}

}
