/*
 * FreeModbus Libary: ATMega168 Port
 * Copyright (C) 2006 Christian Walter <wolti@sil.at>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * File: $Id: portevent.c,v 1.2 2006/05/14 21:55:01 wolti Exp $
 */

/* ----------------------- Modbus includes ----------------------------------*/
#include "mb.h"
#include "mbport.h"
#include <util/atomic.h>

/* ----------------------- Variables ----------------------------------------*/
#define QueueSize 2
static union {
    eMBEventType events[QueueSize];
    uint16_t buf;
} eQueuedEvent;

UCHAR     xQueueEvents;

/* ----------------------- Start implementation -----------------------------*/
BOOL
xMBPortEventInit( void )
{
    xQueueEvents = 0;
    return TRUE;
}

BOOL
xMBPortEventPost( eMBEventType eEvent )
{
    if (xQueueEvents < QueueSize) {
        ATOMIC_BLOCK(ATOMIC_RESTORESTATE){
            eQueuedEvent.events[xQueueEvents] = eEvent;
            xQueueEvents++;
        }
    }
#ifdef DEBUG_MB
    else {
        DEBUG_MB('"');
    }
#endif
    return TRUE;
}

BOOL
xMBPortEventGet( eMBEventType * eEvent )
{
    BOOL            xEventHappened = FALSE;

    ATOMIC_BLOCK(ATOMIC_RESTORESTATE){
    if( xQueueEvents > 0 )
    {
        *eEvent = eQueuedEvent.events[0];
        xQueueEvents--;
        eQueuedEvent.buf = eQueuedEvent.buf >> 8;
        xEventHappened = TRUE;
    }
    }
    return xEventHappened;
}
