/*
 * FreeModbus Libary: ATMega168 Port
 * Copyright (C) 2006 Christian Walter <wolti@sil.at>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * File: $Id: porttimer.c,v 1.4 2006/09/03 11:53:10 wolti Exp $
 */

/* ----------------------- AVR includes -------------------------------------*/
#include <avr/io.h>
#include <avr/interrupt.h>

/* ----------------------- Platform includes --------------------------------*/
#include "port.h"
//#include "iocompat.h"
#include <timer-defs.h>


/* ----------------------- contiki includes --------------------------------*/
#include "contiki-conf.h"
#include <contiki.h>
#include "mbtask.h"
/* ----------------------- Modbus includes ----------------------------------*/
#include <mb.h>
#include <mbstruct.h>

/* ----------------------- Defines ------------------------------------------*/
#define MB_TIMER_PRESCALER      ( 1024UL )
#define MB_TIMER_TICKS          ( F_CPU / MB_TIMER_PRESCALER )
#define MB_50US_TICKS           ( 20000UL )

/* ----------------------- Static variables ---------------------------------*/
static USHORT   usTimerOCRADelta;
static USHORT   usTimerOCRBDelta;

/* ----------------------- Start implementation -----------------------------*/
BOOL
xMBPortTimersInit( USHORT usTim1Timerout50us )
{
    usTimerOCRADelta =
        ( MB_TIMER_TICKS * usTim1Timerout50us ) / ( MB_50US_TICKS );
    MBTCCR = 0x00;

    vMBPortTimersDisable(  );

    return TRUE;
}

void vMBPortTimersEnable(  )
{
    MBTCNT = 0x00;
    if( usTimerOCRADelta > 0 )
    {
        MBTIMSK |= _BV( MBOCIE );
        MBOCR = usTimerOCRADelta;
    }

    MBTCCR |= TIMER2_SCALE_1024;
}

void vMBPortTimersDisable(  )
{
    /* Disable the timer. */
    MBTCCR &= ~(TIMER_SCALE_MASK);
    /* Disable the output compare interrupts for channel A/B. */
    MBTIMSK &= ~( _BV( MBOCIE ) );
    /* Clear output compare flags for channel A/B. */
    MBTIFR |= _BV( MBOCF ) ;
}

SIGNAL( MBSIG_OUTPUT_COMPARE )
{
    if (pxMBPortCBTimerExpired(  )) {
        process_poll(&modbus_poller);}
}
