/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
 * Copyright (c) 2010 Alexandr Litjagin (aka AlexRayne) <alexraynepe196@lavabit.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * this is a dummy implementation of port.h interface part used for expose 
 *  to mb headers part of porting general definitions - types, macrodefinitins
 *  used by heeaders, and it just provides port header. 
 *  implementation part of mb project uses port.h header, and it can be used
 *  to provide additional platform specific code to mb implementation, still 
 *  using mb headers avoiding circular headers including.
 *  
 */
#ifndef _protoport_h_
#define _protoport_h_

/* ----------------------- Protocol TimeOuts --------------------------------*/
#include "contiki-conf.h"
#include <contiki.h>

#define MB_ACK_TIMEOUTms                1
#define MB_TURNAROUND_TIMEOUTms         1

#define MB_ACK_TIMEOUT  (( CLOCK_SECOND * MB_ACK_TIMEOUTms / 1000)+5)
#define MB_TURNAROUND_TIMEOUT   (( CLOCK_SECOND * MB_TURNAROUND_TIMEOUTms / 1000)+5)
#define MB_TXLOCK_TIMEOUT 2

#include "mblocal.h"

#endif