/*
 * FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

#include "runtime/lib.h"
#include "kernel/uos.h"
#include <kernel/internal.h>
/* ----------------------- Modbus includes ----------------------------------*/
#include <port.h>
#include <mb.h>
#include <mbport.h>

#include "portevent.h"

/*-----------------------    EventsQue    -----------------------------------*/
/* эта безлоковая очередь расчитана на без-конкурентное считывание (одним приемником)
 *  и без-конкурентную запись (в прерываниях)
 *  МИПС не имеет дешевых интерлоков, поэтому сделать больше не вижу как
 * */
#define eQueueIMASK 1
#define eQueueSize  (1<<eQueueIMASK)
struct _EventsQue{
    eMBEventType    events[eQueueSize];
    unsigned        rdi;
    unsigned        wri;
};
typedef struct _EventsQue EventsQue;

void QueInit(EventsQue* dst){
    dst->rdi = 0;
    dst->wri = 0;
}

eMBEventType QueGet(EventsQue* src){
    unsigned idx = src->rdi;
    eMBEventType res = src->events[idx];
    src->events[idx] = (eMBEventType)0;
    if (res == 0)
        ;
    else
        src->rdi = (idx+1) & eQueueIMASK;
    return res;
}

CODE_ISR 
BOOL QuePut(EventsQue* src, eMBEventType data){
    unsigned idx = src->wri;
    eMBEventType res = src->events[idx];
    if (res > 0)
        return FALSE;
    src->events[idx] = data;
    src->wri = (idx+1) & eQueueIMASK;
    return TRUE;
}

BOOL QueHave(EventsQue* src){
    return (src->wri != src->rdi);
} 
/* ----------------------- Variables ----------------------------------------*/
EventsQue eQueuedEvent;
volatile UCHAR     xQueueEvents;

/* ----------------------- Start implementation -----------------------------*/
BOOL
xMBPortEventInit( void )
{
    QueInit(&eQueuedEvent);
    xQueueEvents = 0;
    return TRUE;
}

CODE_ISR 
BOOL
xMBPortEventPost( eMBEventType eEvent )
{
    BOOL ok;
    if (MB_PortIsWithinException())
        ok = QuePut(&eQueuedEvent, eEvent);
    else {
        //запись событий у нас может происходить и из пользовательского потока 
        // для этого варианта придется блокировать проц
        arch_state_t x;
        arch_intr_disable (&x);
        ok = QuePut(&eQueuedEvent, eEvent);
        arch_intr_restore (x);
    }
#ifdef DEBUG_MB
    if (!ok)
        DEBUG_MB('"');
#endif
    return ok;
}

BOOL
xMBPortEventGet( eMBEventType * eEvent )
{
    eMBEventType res = QueGet(&eQueuedEvent);
    if (res == 0)
        return FALSE;
    *eEvent = res;
    return TRUE;
}

BOOL MBHasEvent(){
    return QueHave(&eQueuedEvent);
}

