/* 
 * FreeModbus Libary: A portable Modbus implementation for Modbus ASCII/RTU.
    general types and language defines for platform scpecifics stuff library
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 *  
 * this is a dummy implementation of port.h interface part used for expose
 *  to mb headers part of porting general definitions - types, macrodefinitins
 *  used by heeaders, and it just provides port header.
 *  implementation part of mb project uses port.h header, and it can be used
 *  to provide additional platform specific code to mb implementation, still
 *  using mb headers avoiding circular headers including.
 */

#ifndef _MODBUS_PORTGENERAL_h_
#define _MODBUS_PORTGENERAL_h_

#include <stddef.h>
#include "kernel/uos.h"


/* ----------------------- Defines ------------------------------------------*/
#ifndef INLINE
#ifdef __cplusplus
#define INLINE                      inline
#else
#define	INLINE                      inline static
#endif
#endif

/** this macros provided by portgen.h and aided to provide accurate linking of code
 * */
// this routines are plased in faster memory region
#define MB_CODE_FAST CODE_FAST
// this routines are used by ISR and plased in ISR`s memory region
#define MB_CODE_ISR  CODE_ISR

#define PR_BEGIN_EXTERN_C           extern "C" {
#define	PR_END_EXTERN_C             }

//#define assert( x )

typedef char    BOOL;

#ifndef TRUE
#define TRUE            1
#endif

#ifndef FALSE
#define FALSE           0
#endif

typedef unsigned char UCHAR;
typedef char    CHAR;

typedef unsigned short USHORT;
typedef short   SHORT;

typedef unsigned long ULONG;
typedef long    LONG;

typedef unsigned UFRAMESIZE;
#define UFRAMESIZE UFRAMESIZE

/**MB_PORT_HAS_CLOSE enables mbport:vMBPortClose usage
 * \relatealso  vMBPortClose
 * */
#define MB_PORT_HAS_CLOSE       1

//* PLAIN_HOLDREG_ADRESS_BEHAVIOUR declares using adressmaping offset 
//*     from 0 (as for JBUS).insteard standart MODBUS offset from 1. this offset
//*     takes to account for pass reg-adress in function-handlers CallBacks
//*     reg-adress in MODBUS-frame takes with offset0
#define PLAIN_HOLDREG_ADRESS_BEHAVIOUR

//* if stack variables are more complex vs static ones - better use statics for size&speed optimize
//*  for multiple realisation theres is no effort
//#define  MB_LOCAL_SPEC static

//#include <common.h>

#endif
