/*
    elvees stuff library
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#ifndef MODBUS_USART_DEFS_
#define MODBUS_USART_DEFS_

//#include <multicore/nvcom02t.h>
#include <multicore/nvcom02t/nvcom02_mem_map.h>
#include <multicore/nvcom02t/nvcom02_system_regs.h>
#include <multicore/nvcom02t/nvcom02_uart_regs.h>
#include <multicore/nvcom02t/nvcom02_mfbsp_regs.h>
#include <multicore/mcsl_system.h>

/* ----------------------- RS485 specifics ----------------------------------*/
#include "hwconfig.h"

#ifdef UART_MODBUS
#   define UART_IO(port)        UART_MODBUS
#   define UART_IO_EVT(io)      UART_MODBUS_EVT
#else
#   define UART_IO(port) ((port==0)? UART0 : UART1)
#   define UART_IO_EVT(io)      ((io == &UART0)? IRQ_EVT_UART0 : (()io == &UART1)? IRQ_EVT_UART1 : -1
#endif

static inline 
unsigned UART_BAUD_CALC(unsigned baud_rate, unsigned long f_osc){
    return MC_DL_BAUD(f_osc, baud_rate);
}

static inline 
void uart_rx_enable( UART_REGS_TYPE* p){
        p->LCR.data = MC_LCR_8BITS;
        p->MSR.data = 0;
        p->MCR.data = MC_MCR_DTR | MC_MCR_RTS | MC_MCR_OUT2;
        p->FCR.data = MC_FCR_RCV_RST | MC_FCR_XMT_RST | MC_FCR_ENABLE;
}

#ifdef  DE_ENABLE

#ifndef MBU_DE_PORT
#   define MBU_DE_PORT     MFBSP0
#   define MBU_DE_PIN      0x4
#   define MBU_RE_PIN      0x5
#endif

static inline 
void DE_ON() {MBU_DE_PORT.GPIO_DR.data |= MBU_DE_PIN;}
static inline 
void DE_OFF(){MBU_DE_PORT.GPIO_DR.data &= ~MBU_DE_PIN;}

static inline 
void DE_INIT(){
    MBU_DE_PORT.DIR.data     |= MBU_DE_PIN;
    DE_OFF();
}

#else
#define DE_INIT()
#define DE_ON()
#define DE_OFF()
#endif

#ifdef  RE_ENABLE

#ifndef MBU_DE_PORT
#   define MBU_DE_PORT     MFBSP0
#   define MBU_DE_PIN      0x4
#   define MBU_RE_PIN      0x5
#endif

static inline 
void RE_ON(){MBU_RE_PORT.GPIO_DR.data &= ~MBU_nRE_PIN;}
static inline
void RE_OFF() {MBU_RE_PORT.GPIO_DR.data |= MBU_nRE_PIN;}

static inline 
void RE_INIT(){
    MBU_RE_PORT.DIR.data     |= MBU_nRE_PIN;
    RE_OFF();
}

#else
#define RE_INIT()
#define RE_ON()
#define RE_OFF()
#endif

#ifdef MC_UART_FIFO_SIZE
#define MODBUS_FIFOTX_SIZE MC_UART_FIFO_SIZE
#else
#define MODBUS_FIFOTX_SIZE 1
#endif


#endif //MODBUS_USART_DEFS_
