#ifndef _mb_multyport_wraper_h_
#define _mb_multyport_wraper_h_
/*
 * FreeModbus Libary: uOS-elvees Port
 * ru UTF8
    Copyright (C) 2015  Alexandr Litjagin (aka AlexRayne) AlexRaynePE196@gmail.com
                                                          AlexRaynePE196@hotbox.ru
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   here is CRUTCHES wrappers on ModBus v1.6 definitions, that intends to implement
   new v2 layout, allow multiple ModBus instances co-exists in one system.

   there is underlying wraps on <mbmulty.h> structures, for global code refactor.

*/

#include <mbmulty.h>

#if MB_MULTY_PORTS > 0

#define ucMBAddress     (MB_SELF->Address)
#define eMBStatus       (MB_SELF->Status)
#define eMBState        (MB_SELF->State)
#define eMBCurrentMode  (MB_SELF->CurrentMode)

#   ifdef MB_USE_FPTRCUR
#define ref_MBFramePostCur    (MB_SELF->FramePostCur)
#define ref_MBFrameSendCur    (MB_SELF->FrameSendCur)
#define ref_MBFrameStartCur   (MB_SELF->FrameStartCur)
#define ref_MBFrameStopCur    (MB_SELF->FrameStopCur)
#define ref_MBFrameReceiveCur (MB_SELF->FrameReceiveCur)
#define ref_MBFrameCloseCur   (MB_SELF->FrameCloseCur)

#define ref_MBFrameCBByteReceived     (MB_SELF->FrameCBByteReceived)
#define ref_MBFrameCBTransmitterEmpty (MB_SELF->FrameCBTransmitterEmpty)
#define ref_MBPortCBTimerExpired      (MB_SELF->PortCBTimerExpired)

#define ref_MBFrameCBReceiveFSMCur    (MB_SELF->FrameCBReceiveFSMCur)
#define ref_MBFrameCBTransmitFSMCur   (MB_SELF->FrameCBTransmitFSMCur)



#define peMBFramePostCur(...)    (MB_SELF->FramePostCur)(MB_WITH_SELF   __VA_ARGS__)
#define peMBFrameSendCur(...)    (MB_SELF->FrameSendCur)(MB_WITH_SELF   __VA_ARGS__)
#define pvMBFrameStartCur(   )   (MB_SELF->FrameStartCur)(MB_SELF)
#define pvMBFrameStopCur(   )    (MB_SELF->FrameStopCur)(MB_SELF)
#define peMBFrameReceiveCur(...) (MB_SELF->FrameReceiveCur)(MB_WITH_SELF    __VA_ARGS__)
#define pvMBFrameCloseCur(   )   (MB_SELF->FrameCloseCur)(MB_SELF)

#define pxMBFrameCBByteReceived()     (MB_SELF->FrameCBByteReceived)(MB_SELF)
#define pxMBFrameCBTransmitterEmpty() (MB_SELF->FrameCBTransmitterEmpty)(MB_SELF)
#define pxMBPortCBTimerExpired()      (MB_SELF->PortCBTimerExpired)(MB_SELF)

#define pxMBFrameCBReceiveFSMCur(...)    (MB_SELF->FrameCBReceiveFSMCur)(MB_SELF)
#define pxMBFrameCBTransmitFSMCur(...)   (MB_SELF->FrameCBTransmitFSMCur)(MB_SELF)

#   endif//MB_USE_FPTRCUR

#define xFuncHandlers   (MB_SELF->FuncHandlers)



#define ucSentAddress   (MBC_SELF->SentAddress)
#define SentFrameBuf    (MBC_SELF->SentBuf)
#define SentFrameLength (MBC_SELF->SentLength)

//ACK frame valid after post completes with ok
#define MBACKFrame      (MBC_SELF->ACKFrame)
#define MBACKAddress    (MBC_SELF->ACKAddress)
#define MBACKLength     (MBC_SELF->ACKLength)
#define MBRetry_count   (MBC_SELF->retry_count)
#define MBPostState     (MBC_SELF->PostState)
#define MBServe_state   (MBC_SELF->state)

#define RETRY_LIMIT     (MBC_SELF->retry_limit)
#define MB_SENTOK_CB(x)     if (MBC_SELF->On_SentOk != 0)   (*MBC_SELF->On_SentOk)(MBC_WITH_SELF x)
#define MB_ACKERROR_CB(x)   if (MBC_SELF->On_AckError != 0) (*MBC_SELF->On_AckError)(MBC_WITH_SELF x)
#define MB_ERROR_CB(x)      if (MBC_SELF->On_Error != 0)    (*MBC_SELF->On_Error)(MBC_WITH_SELF x)



#else  //MB_MULTY_PORTS > 0

#   ifdef MB_USE_FPTRCUR
#define ref_MBFramePostCur    pvMBFrameStartCur
#define ref_MBFrameSendCur    pvMBFrameStopCur
#define ref_MBFrameStartCur   peMBFrameSendCur
#define ref_MBFrameStopCur    peMBFramePostCur
#define ref_MBFrameReceiveCur peMBFrameReceiveCur
#define ref_MBFrameCloseCur   pvMBFrameCloseCur

#define ref_MBFrameCBByteReceived     pxMBFrameCBByteReceived
#define ref_MBFrameCBTransmitterEmpty pxMBFrameCBTransmitterEmpty
#define ref_MBPortCBTimerExpired      pxMBPortCBTimerExpired

#define ref_MBFrameCBReceiveFSMCur    pxMBFrameCBReceiveFSMCur
#define ref_MBFrameCBTransmitFSMCur   pxMBFrameCBTransmitFSMCur
#   endif
#endif //!MB_MULTY_PORTS > 0

#endif //_mb_multyport_wraper_h_
