using System;

namespace freetrain.world.soccerstadium
{
	/// <summary>
	/// Opponent team.
	/// </summary>
	[Serializable]
	public class OpponentTeam
	{
		/// <summary> Name of the team. </summary>
		public readonly string name;
		/// <summary> Strength of the team. </summary>
		public readonly int strength;
		/// <summary> Popularity of the team. </summary>
		public readonly int popularity;

		private OpponentTeam( string _name, int _strength, int _popularity ) {
			this.name = _name;
			this.strength = _strength;
            this.popularity = _popularity;
		}

		public static readonly OpponentTeam[] OPPONENTS = new OpponentTeam[]{
			new OpponentTeam("yJ^",0,10),
			new OpponentTeam("\feBIRx",10,20),
			new OpponentTeam("Ós~TK",10,40),
			new OpponentTeam("Ökx}[",20,60),
			new OpponentTeam("iCrbNXV`",20,30),
			new OpponentTeam("{AWW[",30,50),
			new OpponentTeam("Ko",30,50),
			new OpponentTeam("BbZ",40,40),
			new OpponentTeam("_F}mX",40,70),
			new OpponentTeam("T\b`F",40,60),
			new OpponentTeam("Ws֌",50,70),
			new OpponentTeam("cC]",50,50),
			new OpponentTeam("BAJ^[",50,60),
			new OpponentTeam("Ag[Y",60,90),
			new OpponentTeam("쉮NnX",60,70),
			new OpponentTeam("FC",70,70),
			new OpponentTeam("Yau[X",90,100),
			new OpponentTeam("XGXvY",100,80)
		};


		/// <summary>
		/// Select one team randomly.
		/// </summary>
		public static OpponentTeam drawRandom() {
			return OPPONENTS[Const.rnd.Next(OPPONENTS.Length)];
		}
	}
}
