// 2008.09.06 YZ Add forwarding and reverse & forwarding option
// 2010.04.01 riorio Add TURNING reverse option , Original foobarbazer
using System;
using System.Collections;
using freetrain.world.rail;
using System.Diagnostics;

namespace freetrain.world.rail.tattc
{
	/// <summary>
	/// StationHandler that follows the detailed rules.
	/// </summary>
	[Serializable]
	internal class AdvancedStationHandler : StationHandler {
		public AdvancedStationHandler() {}


		internal readonly RuleCollection rules = new RuleCollection();

		[Serializable]
		internal class RuleCollection : CollectionBase {
			public void add( AdvStationRule rule ) {
				this.List.Add(rule);
			}
			public void remove( AdvStationRule rule ) {
				this.List.Remove(rule);
			}
			public void insert( int idx, AdvStationRule rule ) {
				this.List.Insert( idx, rule );
			}
			public void set( int idx, AdvStationRule rule ) {
				this.List[idx] = rule;
			}
		}

		internal TimeLength checkTurn(Train train, int forwarding) {

          if( forwarding==-1000 || forwarding==-1 ){ // -1000=], -1=]
          // 擪
				Train.TrainCar headCar=train.head;
				CarState.Inside ss=headCar.state.asInside();
				if(ss==null) {
	              return TimeLength.fromMinutes( forwarding );
	            }
	
				// 擪Ԃ̈ʒu
				Location headLoc=ss.location;
	
                // Ԃ̎ԗ(Car)̔z
                Train.TrainCar[] cars = new Train.TrainCar[train.length];
                int idx = train.length;

			    // Ԃ̐is. ォ牺Ȃtrue
			    // CS0165΍ŏ
			    bool bToLower = false;

				// Ureverse()
				// Ō㕔܂ł̊eԗ݂H𒲂ׂ
				train.reverse();
				Train.TrainCar tailCar=headCar;
	
				while(tailCar != null) {
					cars[--idx] = tailCar;

					ss = tailCar.state.asInside();
					if(ss == null){
						return TimeLength.fromMinutes( forwarding );
					}
					RailRoad rr = RailRoad.get(ss.location);
					if(rr == null){
						return TimeLength.fromMinutes( forwarding );
					}

					// |CgorJ[u
					// -- Ĕzu,ĔzuOƈقȂɔzu鋰ꂪ
					int d1 = -1, d2 = -1;
					for(int i = 0; i < 8; i++) {
						if(rr.hasRail(Direction.get(i))) {
							if(d1 == -1)
								d1 = i;
							else if(d2 == -1) {
								if(i - d1 != 4)	// |CgorJ[u
								{
									return TimeLength.fromMinutes( forwarding );
								}
								d2=i;
							}
							else {
								return TimeLength.fromMinutes( forwarding );
							}
						}
					}	// for

                    // 1̏ꍇ
				    if(train.length == 1) {
					    // 𒲂ׂ
					    //  - isȂ牽Ȃ
					    Direction d = rr.guide();
					    if(d.isSharp == false) {
						    return TimeLength.fromMinutes(-1000);
				  	    }
					    // Train::reverse()R[O
					    // is𒲂ׂ()
					    bToLower = (d.index <= 2);
  					    break;
				    }

					// ̎ԗ
					tailCar = tailCar.previous;
				}	// while
	
				// HɗԂ鎖mF,
				// ␂Ȃ牽Ȃ
				Location tailLoc=ss.location;
                if( train.length > 1 ){
				    if(tailLoc.x-headLoc.x==tailLoc.y-headLoc.y)
	                    {
	                        return TimeLength.fromMinutes( forwarding );
	                    }
				     bToLower = ((tailLoc.y < headLoc.y) || (tailLoc.x > headLoc.x));
			    }
	
			    // Train::place()͈ȉ̎dl.
			    //  1. w肵ʒuɍŌԗzu
			    //  2. Hł, ɌĕҐLт
			    // Đݒu̍ۂ,
			    // ŌƐ擪Ԃ̂ǂw
			    // ݒu邩f
			    Location loc = bToLower ? headLoc : tailLoc;

                // ԓP, Đݒu
				// UԂP
				//  Train::remove()R[,
				//  ̃\[XgetStopTimeSpan()R[obNĂnho^,
				//  ɃR[Train::place()ɂčēo^ƂȂ.
				//  ꂪȂ̂̗ԂtgܕԂ{, ̗ԂdԂɊׂ.
				//  ̂, Train::remove()R[ɎԗP̃R[ĥ݂p.  
				foreach(Train.TrainCar car in cars) {
					car.remove();
				}	/* foreach */

				// X̐isォ牺̏ꍇ
				if(bToLower) {
					// t]
					//  - ֐` Train::reverse() R[,
					//    ̌ɖ߂iDƂȂ
					train.reverse();

					// carszɂт
					// ֐` Train::reverse() R[Ƃɍ쐬̂ł, 
					// ōēx Train::reverse() R[, 
					// ɕׂȂ.
					for(int i = 0; i < cars.Length / 2; i++) {
						Train.TrainCar t = cars[i];
						cars[i] = cars[cars.Length - (i + 1)];
						cars[cars.Length - (i + 1)] = t;
					}	/* for */
				}

				// Đݒu
				//  - PƓl, Train::place()ԗݒũR[ĥ݂p.
				//  - isǂł,
				//    ԗݒu͉(Ō)(擪)֌čs.
				{
					int idx2 = train.length;
					Direction d = null;
					do {
						idx2--;
						RailRoad rr = RailRoad.get(loc);
						if(d == null) {
							d = rr.dir1;
						}
						cars[idx2].place(loc, d);
						d = rr.guide();
						loc += d;
					} while(idx2 != 0);
				}
            
				// is߂ȂiTimeLength.fromMinutes( forwarding )Ԃreverse邽߁j
				if(bToLower) {
					train.reverse();
				}
				return TimeLength.fromMinutes( forwarding );
            }
            return TimeLength.fromMinutes( -1 );
        }

		private readonly TimeLength MIN_STOP_TIME = TimeLength.fromMinutes(10);

		internal override TimeLength getStopTimeSpan( Train train, int callCount ) {
			Clock clock = World.world.clock;

			if( callCount==0 ) {
				// decide whether to stop or pass
				foreach( AdvStationRule rule in rules ) {
					if( rule.action==StationAction.pass && rule.matches(clock) )
						return TimeLength.ZERO;	// pass
					if( rule.action==StationAction.stop && rule.matches(clock) )
						return MIN_STOP_TIME;	// force the train to stop at least this much
				}
				// by default, we stop.
				return MIN_STOP_TIME;

			} else {
				// TODO: do the efficient computation by using the getNextMatch method.

				// decide whether to go or sit still
				foreach( AdvStationRule rule in rules ) {
					if( rule.action==StationAction.go && rule.matches(clock) )
						return TimeLength.ZERO;	// go
					if(( rule.action==StationAction.reverse || rule.action==StationAction.reverse2)
                       && rule.matches(clock) )
                         {
						    if(rule.action==StationAction.reverse2) {
							    return checkTurn(train, -1);
						    }
  						  return TimeLength.fromMinutes(-1);	// turn around and go
                        }
					if( rule.action==StationAction.stop && rule.matches(clock) )
						break;		// can't go

#region YZ_20080906_ADDED
					if (rule.action == StationAction.forwarding && rule.matches(clock)) {
						return TimeLength.fromMinutes(-999);  // forwarding train
                    }
#region riorio_20100401_ADDED
					if ((rule.action == StationAction.rforwarding || rule.action==StationAction.rforwarding2)
                        && rule.matches(clock)) {
                        if( rule.action==StationAction.rforwarding2) {
                                return checkTurn(train, -1000);
						    }
						return TimeLength.fromMinutes(-1000); // reverse and forwarding train
                    }
#endregion
#endregion
				}

				// the unit of rules is 10 minutes. So wait until the next ten minutes break
				int next = (60-clock.minutes)%10;
				if(next==0)	next=10;
				return TimeLength.fromMinutes(next);
			}
		}
	}

	[Serializable]
#region YZ_20080906_MODIFIED
//	internal enum StationAction {
//		pass,	// pass the station
//		stop,	// sit still
//		go,		// go
//		reverse	// reverse
//	}
	internal enum StationAction {
		pass,       // pass the station
		stop,       // sit still
		go,         // go
		reverse,    // reverse
        forwarding, // forwarding
        rforwarding,// reverse forwarding
		reverse2,    // reverse and TURN
        rforwarding2 // reverse and TURN forwarding
	}
#endregion

	[Serializable]
	internal class AdvStationRule : TimeMask {
		internal StationAction action = StationAction.go;
	}
}
