﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.Serialization;
using nft.framework.drawing;

using Geocon = nft.core.geometry.GeometricConstants;

namespace nft.core.geometry {
    public interface ITerrainPolygon {
        ushort ID {get;}

        /// <summary>
        /// Returns 2D bounds rectangle which contains all verticis points.
        /// </summary>
        Rectangle GetBounds(Scaler sc);

        /// <summary>
        /// Calc verticis according to the ViewFactor. A bit heavy process.
        /// </summary>
        /// <param name="vf"></param>
        /// <returns></returns>
        Point[] GetVerticis(Scaler sc);

        Point3D[] GetVerticis3D();
    }
}
