using System;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.Serialization;

namespace nft.core.geometry {
    public interface IViewDirectionEnum
    {
        int index { get; }
    }

    /// <summary>
    /// 8 directions (Int16).
    /// Cardinal and inter-cardinal directions.
    /// </summary>
    public enum ViewDirection8 : short {
        BEHIND, LEFT, FRONT, RIGHT,
        LEFTBEHIND, LEFTFRONT, RIGHTFRONT, RIGHTBEHIND,
        UNDEFINED = short.MaxValue
    }

    /// <summary>
    /// 4 cardinal directions (Int16).
    /// </summary>
    [Serializable]
    public enum ViewDirection : short {
        BEHIND, LEFT, FRONT, RIGHT
        //INVALID = byte.MaxValue
    }

    /// <summary>
    /// 4 inter cardinal directions (Int16).
    /// </summary>
    [Serializable]
    public enum DiagonalViewDirection : short {
        LEFTBEHIND = 4, LEFTFRONT, RIGHTFRONT, RIGHTBEHIND
        //INVALID = byte.MaxValue
    }
}
