﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using nft.framework.drawing;
using nft.framework;
using nft.framework.plugin;
using nft.contributions.graphics;
using nft.core.geometry;
using nft.core;

namespace nft.debug
{
    public partial class TestXnaForm : Form
    {
        public TestXnaForm()
        {
            InitializeComponent();
        }

        private GraphicManagerEx GM
        {
            get { return GraphicManagerEx.GraphicManager; }
        }

        List<I3DObject> structures = new List<I3DObject>();
        protected override void OnLoad(EventArgs e)
        {
            CtbImageResource ir1 = PluginManager.theInstance.GetContribution(@"test\tex112x136x96") as CtbImageResource;
            CtbImageResource ir2 = PluginManager.theInstance.GetContribution(@"test\tex32x48x56") as CtbImageResource;
            ITexture tx1 = GM.CreateStaticTexture(ResourceKey.CreateKey(ir1, ir2.ID), ir1.ImageSrc);
            ITexture tx2 = GM.CreateStaticTexture(ResourceKey.CreateKey(ir2, ir2.ID), ir2.ImageSrc);
            ICubicStructure st1 = GM.CreateStructure(0, null, tx1, new Point3D(112, 96, 136));
            ICubicStructure st2 = GM.CreateStructure(0, null, tx2, new Point3D(32, 56, 48));
            st1.Location = new PointF3D(40f, -20f, -40f);
            st2.Location = new PointF3D(-20f, 40f, -40f);
            structures.Add(st1);
            structures.Add(st2);
            Point3D[] vertices = new Point3D[] { new Point3D(0, 0, 0), new Point3D(0, 32, 4), new Point3D(32, 0, 0) };
            ITerrainPlateTemplate tpt = GM.CreateTerrainTemplate(null, Color.HotPink, vertices, 2f);
            ITerrainPlate tp = GM.CreateTerrainPlate(0, tpt);
            tp.Location = new PointF3D(-16f, 0f, -16f);
            structures.Add(tp);
            renderViewPanel1.Surface.Objects = structures;
            base.OnLoad(e);
        }

        private void renderViewPanel1_Click(object sender, EventArgs e)
        {
            Debug.WriteLine("Click event called.");
        }

        private void renderViewPanel1_MouseClick(object sender, MouseEventArgs e)
        {
            Debug.WriteLine("MouseClick event called.");
        }

        private void renderViewPanel1_KeyPress(object sender, KeyPressEventArgs e)
        {
            Debug.WriteLine("KeyPress event called." + e.KeyChar);
        }
    }
}
