﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace nft.impl.view_old {
    public struct Margin {
        int l, r, t, b;
        public Margin(int left, int top, int right, int bottom) {
            this.l = left;
            this.t = top;
            this.r = right;
            this.b = bottom;
        }

        public Margin(int horzMargin, int vertMargin) {
            l = r = horzMargin;
            t = b = vertMargin;
        }

        public Margin(int allside) {
            l = r = t = b = allside;
        }

        public int Left { get { return l; } set { l = value; }}
        public int Right { get { return r; } set { r = value; } }
        public int Top { get { return t; } set { t = value; } }
        public int Bottom { get { return b; } set { b = value; } }
        
        public int TotalHeight { get { return t + b; } }
        public int TotalWidth { get { return l + r; } }

        public Rectangle Inflate(Rectangle org) {
            Rectangle r = new Rectangle(org.X - l, org.Y - t, 
                org.Width + TotalWidth, org.Height + TotalHeight);
            return r;
        }

        public void Inflate(ref Rectangle target) {
            target.X -= l;
            target.Y -= t;
            target.Inflate(TotalWidth, TotalHeight);
        }


        public Rectangle Deflate(Rectangle org) {
            Rectangle r = new Rectangle(org.X + l, org.Y + t,
                org.Width - TotalWidth, org.Height - TotalHeight);
            return r;
        }

        public void Deflate(ref Rectangle target) {
            target.X += l;
            target.Y += t;
            target.Width-=TotalWidth;
            target.Height-=TotalHeight;
        }
    }
}
