﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Drawing;
using nft.framework.drawing;
using nft.core.geometry;
using Geocon = nft.core.geometry.GeometricConstants;

namespace nft.impl.view_old {
    /// <summary>
    /// とりあえず作ってみたけど、使用中止？
    /// 各Xカラム毎にY軸方向にどこまで処理済みかを持たせれば十分。
    /// </summary>
    public class QVGridFillMap {
        private UInt16[] map;
        private int widthPixel;
        private Point3DV offset;
        private Size szWorld;
        private Size szUnit;
        private Rectangle rect;
        public QVGridFillMap(int viewWidthInPixel) {
            Realloc(viewWidthInPixel);
        }

        public void Realloc(int viewWidthInPixel) {
            widthPixel = viewWidthInPixel;
            int n = (int)Math.Ceiling(widthPixel / (double)Geocon.CellWidthPixel);
            map = new UInt16[n];
        }

        public int ViewWidthInPixel { get { return widthPixel; } }

        public void InitMap(Size sizeWorld, Rectangle viewrect, Scaler scaler) {
            Array.Clear(map, 0, map.Length);
            szWorld = sizeWorld;
            int uw = scaler.Scale(Geocon.CellWidthPixel);
            int uh = scaler.Scale(Geocon.CellHeightPixel);
            szUnit = new Size(uw, uh);
            rect = RectUtil.DivideCircumscribe(viewrect, uw, uh);
            rect.Inflate(2, 2);
        }


        private UInt16 this[LocationF loc] {
            get {
                try {
                    return map[GetIndexOf(loc)];
                } catch (IndexOutOfRangeException) {
                    return UInt16.MaxValue;
                }
            }
            set {
                map[GetIndexOf(loc)] = value;
            }
        }

        private int GetIndexOf(LocationF loc) {
            int x = (int)Math.Floor(loc.X - loc.Y);
            int y = (int)Math.Floor(szWorld.Width - loc.X + szWorld.Height - loc.Y - loc.Z);
            return x * rect.Width + y;
        }
    }
}
