﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using DefaultEffect = StockEffects.AlphaTestEffect;

namespace nft.xna
{
    internal class Scene
    {
        static public Matrix IsometricView = new Matrix(
                    1f, 0.5f, 0.5f, 0,
                    0f, 1f, -1f, 0,
                    -1f, 0.5f, 0.5f, 0,
                    0.5f, 0, 0, 1);

        static private DefaultEffect effect = null;

        public static DefaultEffect Prepare(XnaSurface surface) {
            if (effect == null) {
                effect = CreateDefaultEffect(surface);
            } else {
                Prepare2(effect, surface);
            }
            return effect;
        }

        public static DefaultEffect ResetAll(XnaSurface surface) {
            effect = CreateDefaultEffect(surface);
            return effect;
        }

        public static DefaultEffect CreateDefaultEffect(XnaSurface surface) {
            GraphicsDevice dev = surface.GraphicsDevice;
            DefaultEffect ef = new DefaultEffect(dev) {
                World = Matrix.Identity
            };
            Prepare2(ef, surface);
            return ef;
        }


        private static void Prepare2(DefaultEffect ef, XnaSurface surface){
            surface.GraphicsDevice.SetRenderTarget(surface.RenderTarget);
            int vw = surface.Width;
            int vh = surface.Height;
            ef.View = IsometricView * Matrix.CreateLookAt
            (
                new Vector3(0, 0, -10),   //カメラの位置
                new Vector3(0, 0, -5),   //カメラの見る点
                new Vector3(0, 1, 0)    //カメラの上向きベクトル。(0, -1, 0)にすると画面が上下逆になる
            );
            ef.Projection = Matrix.CreateOrthographic
            (
                vw, vh,
                -256f,      //カメラからこれより近い物体は画面に映らない
                256f    //カメラからこれより遠い物体は画面に映らない
            );
        }

    }
}
