using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Diagnostics;
using System.Windows.Forms;

namespace nft.controls
{
	public enum ButtonStateImage :int{ Normal, Hover, Pressed, Disabled };
	/// <summary>
	/// ImageButton ̊Tv̐łB
	/// </summary>
	public class ImageButton : System.Windows.Forms.UserControl
	{
		const int ButtonStateCounts = 4;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		protected ImageList imgList;
        protected Bitmap bmpStrip;
        protected Color colTransKey;
        private ImageList imgListInternal;
		protected bool imgListDispose = false;
		protected readonly short[] stateIndices = new short[4];

		public ImageButton(){
			this.Size = new Size(16,16);
            this.BackColor = Color.Transparent;
		}
	
		public ImageList ImageList { 
			get{ return imgList; } 
			set{
                if (imgList != value){
                    if (imgListInternal != null && imgListInternal != imgList) {
                        imgListInternal.Dispose();
                    }
                    imgList = value;
                    imgListInternal = imgList;
                    colTransKey = imgList.TransparentColor;
                }
			}
		}

        public Bitmap StripSource {
            get { return bmpStrip; }
            set {
                if (bmpStrip != value) {
                    if (imgListInternal != null && imgListInternal != imgList) {
                        imgListInternal.Dispose();
                    }
                    bmpStrip = value;
                    if (value != null) {
                        imgListInternal = new ImageList();
                        int w = bmpStrip.Width >> 2;
                        imgListInternal.ImageSize = new Size(w, bmpStrip.Height);
                        imgListInternal.Images.AddStrip(bmpStrip);
                        imgListInternal.TransparentColor = colTransKey;
                    }
                    imgList = null;
                }
            }
        }

        public Color TransparentKey {
            get {
                if (imgListInternal != null) {
                    return imgListInternal.TransparentColor;
                } else {
                    return colTransKey;
                }
            }
            set {
                this.colTransKey = value;
                if (imgListInternal != null) {
                    imgListInternal.TransparentColor = colTransKey;
                }
            }                
        }

		public bool DisposeImageList {
			get{ return imgListDispose; }
			set{ imgListDispose = value; }
		}

		public void SetModeImageIndices(int normal, int hover, int press, int disable) {
			stateIndices[(int)ButtonStateImage.Normal] = (short)normal;
			stateIndices[(int)ButtonStateImage.Hover] = (short)hover;
			stateIndices[(int)ButtonStateImage.Pressed] = (short)press;
			stateIndices[(int)ButtonStateImage.Disabled] = (short)disable;
		}

		public int IdxNormalImage { 
			get { return stateIndices[(int)ButtonStateImage.Normal]; }
			set { stateIndices[(int)ButtonStateImage.Normal]=(short)value; }
		}
		public int IdxHoverImage { 
			get { return stateIndices[(int)ButtonStateImage.Hover]; }
			set { stateIndices[(int)ButtonStateImage.Hover]=(short)value; }
		}
		public int IdxPressedImage { 
			get { return stateIndices[(int)ButtonStateImage.Pressed]; }
			set { stateIndices[(int)ButtonStateImage.Pressed]=(short)value; }
		}
		public int IdxDisabledImage { 
			get { return stateIndices[(int)ButtonStateImage.Disabled]; }
			set { stateIndices[(int)ButtonStateImage.Disabled]=(short)value; }
		}

		public Image GetImage(ButtonStateImage state){
			try {
                return imgListInternal.Images[stateIndices[(int)state]];
			}catch{
				return SystemIcons.Error.ToBitmap();
			}
		}

        protected override void OnLoad(EventArgs e) {
            base.OnLoad(e);
        }

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
            if (imgListDispose && imgListInternal != null)
                imgListInternal.Dispose();
		}
		
		protected override void OnPaint(PaintEventArgs e) {
			base.OnPaint (e);
			Graphics g = e.Graphics;
			ButtonStateImage bs = ButtonStateImage.Normal;
			
			if(Enabled){
				Point mp = PointToClient(MousePosition);
				if(mp.X>=0 && mp.X<Width && mp.Y>=0 && mp.Y<Height){
					if(Control.MouseButtons==MouseButtons.Left)
						bs = ButtonStateImage.Pressed;
					else
						bs = ButtonStateImage.Hover;
				}				
			} else
				bs = ButtonStateImage.Disabled;
			g.DrawImage(GetImage(bs),0,0,Width,Height);
		}
      
		protected override void OnMouseEnter(EventArgs e) {
            base.OnMouseEnter(e);
            Invalidate();
        }

		protected override void OnMouseLeave(EventArgs e) {
            base.OnMouseLeave(e);
            Invalidate();
        }

		protected override void OnMouseDown(MouseEventArgs e) {
            base.OnMouseDown(e);
            if (e.Button == MouseButtons.Left)
                Invalidate();
        }

		protected override void OnMouseUp(MouseEventArgs e) {
            base.OnMouseUp(e);
            if (e.Button == MouseButtons.Left)
                Invalidate();
        }
        

	}
}
