using System;
using System.Diagnostics;
using System.Windows.Forms;
using nft.util;
using nft.ui.mainframe;
using System.Threading;

namespace Starter
{
	public class Starter
	{
		//[DllImport("DirectDraw.AlphaBlend.dll",EntryPoint="DllRegisterServer")]
		//private static extern void regsvr();

		[STAThread]
		static void Main( string[] args ) 
		{
            if (Debugger.IsAttached) {
                run(args);
            } else {
                Application.SetUnhandledExceptionMode(UnhandledExceptionMode.CatchException);
                Application.ThreadException += new ThreadExceptionEventHandler(Application_ThreadException);
                try {
                    run(args);
                } catch (Exception e) {
                    UIUtil.ShowException("G[܂", e, UIInformLevel.normal);
                }
            }
		}

		private static void run( string[] args ) {
            // start the game
			Application.Run(new MainFrame(args));
		}

        static void Application_ThreadException(object sender, ThreadExceptionEventArgs e) {
            UIUtil.ShowException(e.Exception.Message, e.Exception, UIInformLevel.severe);
        }
	}
}
