using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using nft.framework.plugin;
using nft.contributions.game;
using nft.core.game;
using nft.util;
using nft.controls;

namespace nft.ui.core
{
	/// <summary>
	/// CreateMapForm ̊Tv̐łB
	/// </summary>
    public class CreateMapForm : System.Windows.Forms.Form {
		private System.Windows.Forms.Button btnOk;
        private System.Windows.Forms.Button btnCancel;
        private TabControl tabControl;
        private Panel pnlFooter;
        private MsgAndIconLabel labelMsg;
        private TabPage tabBasic;
        private MapGeneratorListBase contribComboPanel1;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		public CreateMapForm()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();
			labelMsg.ImageList = UIUtil.MsgTypeIcons;
            tabControl.SuspendLayout();
            AddTabPage<CtbTerrainGenerator>("TerrainGenerator", "n`");
            AddTabPage<CtbWorldDivider>("WorldDivider", "n}bv");
            //AddTabPage<CtbWorldDivider>("NatureBuilder", "CEAz");
            //AddTabPage<CtbWorldDivider>("Populator", "ssEYƔzu");
            //AddTabPage<CtbWorldDivider>("RivalMaker", "CoДzu");
            tabControl.ResumeLayout();
		}

        private void AddTabPage<T>(string key, string caption) where T:CtbMapGenerator {
            tabControl.TabPages.Add(key, caption);
            TabPage page = tabControl.TabPages[key];
            MapGeneratorListPanel<T> panel = new MapGeneratorListPanel<T>();
            panel.Dock = DockStyle.Fill;
            page.Controls.Add(panel);
        }

		protected override void OnLoad(EventArgs e)
		{
			base.OnLoad (e);
//			if(ContribListControlHelper.Set(comboLandMaker,"LandMaker",true)>0)
//				comboLandMaker.SelectedIndex = 0;
		}

		#region Windows tH[ fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(CreateMapForm));
            this.btnOk = new System.Windows.Forms.Button();
            this.btnCancel = new System.Windows.Forms.Button();
            this.tabControl = new System.Windows.Forms.TabControl();
            this.tabBasic = new System.Windows.Forms.TabPage();
            this.contribComboPanel1 = new nft.ui.core.MapGeneratorListBase();
            this.pnlFooter = new System.Windows.Forms.Panel();
            this.labelMsg = new nft.controls.MsgAndIconLabel();
            this.tabControl.SuspendLayout();
            this.tabBasic.SuspendLayout();
            this.pnlFooter.SuspendLayout();
            this.SuspendLayout();
            // 
            // btnOk
            // 
            this.btnOk.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOk.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOk.Location = new System.Drawing.Point(433, 4);
            this.btnOk.Name = "btnOk";
            this.btnOk.Size = new System.Drawing.Size(80, 20);
            this.btnOk.TabIndex = 1;
            this.btnOk.Text = "";
            this.btnOk.Click += new System.EventHandler(this.btnOk_Click);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(347, 4);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(80, 20);
            this.btnCancel.TabIndex = 1;
            this.btnCancel.Text = "LZ";
            // 
            // tabControl
            // 
            this.tabControl.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                        | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.tabControl.Controls.Add(this.tabBasic);
            this.tabControl.Location = new System.Drawing.Point(0, 0);
            this.tabControl.Name = "tabControl";
            this.tabControl.SelectedIndex = 0;
            this.tabControl.Size = new System.Drawing.Size(520, 313);
            this.tabControl.TabIndex = 1;
            // 
            // tabBasic
            // 
            this.tabBasic.Controls.Add(this.contribComboPanel1);
            this.tabBasic.Location = new System.Drawing.Point(4, 21);
            this.tabBasic.Name = "tabBasic";
            this.tabBasic.Padding = new System.Windows.Forms.Padding(3);
            this.tabBasic.Size = new System.Drawing.Size(512, 288);
            this.tabBasic.TabIndex = 6;
            this.tabBasic.Text = "";
            this.tabBasic.UseVisualStyleBackColor = true;
            // 
            // contribComboPanel1
            // 
            this.contribComboPanel1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.contribComboPanel1.Location = new System.Drawing.Point(3, 3);
            this.contribComboPanel1.Name = "contribComboPanel1";
            this.contribComboPanel1.PreviewSize = new System.Drawing.Size(64, 64);
            this.contribComboPanel1.PreviewVisible = true;
            this.contribComboPanel1.Size = new System.Drawing.Size(506, 282);
            this.contribComboPanel1.TabIndex = 16;
            // 
            // pnlFooter
            // 
            this.pnlFooter.Controls.Add(this.labelMsg);
            this.pnlFooter.Controls.Add(this.btnOk);
            this.pnlFooter.Controls.Add(this.btnCancel);
            this.pnlFooter.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.pnlFooter.Location = new System.Drawing.Point(0, 315);
            this.pnlFooter.Name = "pnlFooter";
            this.pnlFooter.Size = new System.Drawing.Size(520, 31);
            this.pnlFooter.TabIndex = 3;
            // 
            // labelMsg
            // 
            this.labelMsg.BackColor = System.Drawing.SystemColors.Control;
            this.labelMsg.ImageIndex = -1;
            this.labelMsg.ImageList = null;
            this.labelMsg.Location = new System.Drawing.Point(4, 5);
            this.labelMsg.Message = "";
            this.labelMsg.Name = "labelMsg";
            this.labelMsg.Size = new System.Drawing.Size(309, 19);
            this.labelMsg.TabIndex = 3;
            // 
            // CreateMapForm
            // 
            this.AcceptButton = this.btnOk;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(520, 346);
            this.Controls.Add(this.pnlFooter);
            this.Controls.Add(this.tabControl);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MaximizeBox = false;
            this.Name = "CreateMapForm";
            this.Text = "}bv쐬";
            this.tabControl.ResumeLayout(false);
            this.tabBasic.ResumeLayout(false);
            this.pnlFooter.ResumeLayout(false);
            this.ResumeLayout(false);

		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

        private MapGeneratorListBase GetSelectedListPanel(TabPage page){
            if (page.Controls.Count > 0) {
                return page.Controls[0] as MapGeneratorListBase;
            } else {
                return null;
            }
        }
        
        private void btnOk_Click(object sender, EventArgs e) {
            object result =null;
            ParamSet param = new ParamSet();
            foreach (TabPage page in tabControl.TabPages) {
                MapGeneratorListBase panel = GetSelectedListPanel(page);
                IMapGenerator gen = panel.SelectedGenerator;
                if (gen != null) {
                    panel.RequestCurrentParams(ref param);
                    result = MapGeneService.TheInstance.GenericGenerate(gen,param,result);                 
                    GameManager.theInstance.NewGameFromMap(result as ITerrainMap, BuiltInGameMode.FreeBuild, true);
                }
            }
        }

		#region event handlers
        /*
		private void comboTerrain_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Contribution c =
				ContribListControlHelper.GetContribution(comboTerrain,comboTerrain.SelectedIndex);
			if(c==null)
			{
				txtTerrainDescript.Text = "";
				btnSetupTerrain.Enabled = false;
			}
			else
			{
				txtTerrainDescript.Text = c.Description;
				ITerrainGenerator generator = ((CtbTerrainGenerator)c).Generator;
				btnSetupTerrain.Enabled = generator.IsSetupEnable;
			}
				
		}

		private void comboDivider_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Contribution c =
				ContribListControlHelper.GetContribution(comboDivider,comboTerrain.SelectedIndex);
			if(c==null)
			{
				txtDividerDescript.Text = "";
				btnSetupDivider.Enabled = false;
			}
			else
			{
				txtDividerDescript.Text = c.Description;
				IWorldDivider divider = ((CtbWorldDivider)c).Divider;
				btnSetupDivider.Enabled = divider.IsSetupEnable;
			}		
		}
         */
		#endregion
	}
}
