﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using System.Xml;
using System.Drawing;
using nft.core.geometry;
using nft.framework.drawing;
using System.IO;
using System.Drawing.Imaging;
using System.Diagnostics;

namespace nft.contributions.terrain {
    public class CtbSimpleCliffTexture : Contribution {
        protected static Dictionary<Color, SimpleCliffImgSet> registerdSet = new Dictionary<Color,SimpleCliffImgSet>();
        protected static string CacheDirRoot;
        public readonly Color BaseColor;
        protected SimpleCliffImgSet imgSet;

        public CtbSimpleCliffTexture(Plugin p, CtbCliffTextureFactory factory, XmlElement ctb)
            : base(p, ctb) {
            if (SimpleCliffImgSet.textureFactory == null) {
                SimpleCliffImgSet.textureFactory = factory;
            }
            string text = XmlUtil.GetSingleNodeText(ctb, "basecolor", null);
            BaseColor = ColorUtil.To12BitColor(StringParseUtil.CreateColor(text));
            CreateAndRegister(BaseColor, out imgSet);
        }

        //protected override InitCompleteEventHandler Initialize() {
        //    return null;
        //}

        //public ITexture GetTexture(Scaler scl, CliffPolygon poly, Point3DV hint) {
        //    return imgSet.GetTexture(scl, poly, hint);
        //}

        public ITerrainImageSet<CliffPolygon> TextureSet {
            get { return imgSet; }
        }

        protected static bool CreateAndRegister(Color basecol, out SimpleCliffImgSet imgSet) {
            if (registerdSet.ContainsKey(basecol)) {
                imgSet = registerdSet[basecol];
                return false; // already registerd
            }
            string subdir = string.Format("{0:X6}", basecol.ToArgb() & 0xffffff);
            string path = Path.Combine(SimpleCliffImgSet.textureFactory.DataDirectory, subdir);
            if (!Directory.Exists(path))
                Directory.CreateDirectory(path);
            imgSet = new SimpleCliffImgSet(path, basecol);
            registerdSet.Add(basecol, imgSet);
            return true;
        }

        public override void PrepareCacheData(bool forceUpdate) {
            SimpleCliffImgSet imgSet;
            if (!CreateAndRegister(BaseColor, out imgSet) && forceUpdate) {
                imgSet.DeleteCache();
            }
            imgSet.PrepareCache();
        }
    }

    public class SimpleCliffImgSet : AbstractCliffImgSet {
        protected internal static CtbCliffTextureFactory textureFactory;
        public readonly Color BaseColor;
        internal protected SimpleCliffImgSet(string imageCacheDir, Color basecol) 
            : base(imageCacheDir) {
            this.BaseColor = basecol;
        }

        protected override Bitmap CreateBitmap(Scaler sc, CliffPolygon polygon, Point3DV hint) {
            Point[] pts = polygon.GetVerticis(sc);
            Rectangle bounds = polygon.GetBounds(sc);
            Debug.Assert(bounds.Width * bounds.Height>0,"id="+polygon.ID);
            Bitmap bmp = new Bitmap(bounds.Width, bounds.Height, PixelFormat.Format24bppRgb);
            int R = (BaseColor.R * polygon.Brightness) >> 8;
            int G = (BaseColor.G * polygon.Brightness) >> 8;
            int B = (BaseColor.B * polygon.Brightness) >> 8;
            Color col = Color.FromArgb(R, G, B);
            Bitmap img = textureFactory.GetTextureBitmap(sc, polygon.ID, hint) as Bitmap;
            using (Graphics g = Graphics.FromImage(bmp)) {
                using (Brush br = new SolidBrush(col)) {
                    g.FillRectangle(br, 0, 0, bounds.Width, bounds.Height);
                }
                if (img != null) {
                    img.MakeTransparent(CtbCliffTextureFactory.texFGColor);
                    g.DrawImage(img, 0, 0);
                    img.Dispose();
                }
            }
            return bmp;
        }
    }

}
