﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.contributions.terrain;
using nft.framework.plugin;
using nft.core.geometry;

namespace nft.core {
    /// <summary>
    /// Assign the most suitable graphics for given parameters, among the registerd contributions.
    /// </summary>
    public interface IApparentAssignor {
        ITerrainImageSet<T> GetTerrainTexture<T>(object hint) where T : ITerrainPolygon;
        ITerrainImageSet<GroundPolygon> DefaultLandTexture { get; }
        ITerrainImageSet<CliffPolygon> DefaultCliffTexture { get; }
        ITerrainImageSet<GroundPolygon> UnderWaterTexture { get; }
        ITerrainImageSet<CliffPolygon> UnderWaterCliffTexture { get; }
    }

    /// <summary>
    /// System default implementation of IApparentAssignor.
    /// This class can be used as a base class of custom assignor.
    /// </summary>
    public class DefaultApparentAssignor : IApparentAssignor {
        static readonly string CID_DefGround = "system:BareLandTexture";
        static readonly string CID_DefCliff = "system:DefaultCliffTexture";
        static readonly string CID_UnderWater = "system:UnderWaterTexture";
        static readonly string CID_UnderWaterCliff = "system:UnderWaterCliffTexture";
        
        static public readonly DefaultApparentAssignor TheInstance = new DefaultApparentAssignor();
        protected ITerrainImageSet<GroundPolygon> defaultGroundSet;
        protected ITerrainImageSet<CliffPolygon> defaultCliffSet;
        protected ITerrainImageSet<GroundPolygon> underWaterGroundSet;
        protected ITerrainImageSet<CliffPolygon> underWaterCliffSet;

        protected DefaultApparentAssignor() {
            CtbSimpleGroundTexture ctb1;
            CtbSimpleCliffTexture ctb2;
            ctb1 = PluginManager.GetContribution(CID_DefGround) as CtbSimpleGroundTexture;
            defaultGroundSet = ctb1.TextureSet;
            ctb2 = PluginManager.GetContribution(CID_DefCliff) as CtbSimpleCliffTexture;
            defaultCliffSet = ctb2.TextureSet;

            ctb1 = PluginManager.GetContribution(CID_UnderWater) as CtbSimpleGroundTexture;
            underWaterGroundSet = ctb1.TextureSet;
            ctb2 = PluginManager.GetContribution(CID_UnderWaterCliff) as CtbSimpleCliffTexture;
            underWaterCliffSet = ctb2.TextureSet;

        }

        protected PluginManager PluginManager { get { return PluginManager.theInstance; } }

        #region IApparentAssignor メンバ


        public ITerrainImageSet<GroundPolygon> DefaultLandTexture {
            get {
                return defaultGroundSet;
            }
        }

        public ITerrainImageSet<CliffPolygon> DefaultCliffTexture {
            get {
                return defaultCliffSet;
            }
        }

        public ITerrainImageSet<GroundPolygon> UnderWaterTexture {
            get {
                return defaultGroundSet;
            }
        }

        public ITerrainImageSet<CliffPolygon> UnderWaterCliffTexture {
            get {
                return defaultCliffSet;
            }
        }
        public ITerrainImageSet<T> GetTerrainTexture<T>(object hint) where T : ITerrainPolygon {
            Type type = typeof(T);
            throw new NotImplementedException();
        }

        #endregion
    }
}
