using System;

namespace nft.core.geometry
{
	/// <summary>
	/// TerrainUtil ̊Tv̐łB
	/// </summary>
	public class TerrainUtil
	{
		static readonly short[] vtx_step = new short[]{0,1,2,2,4,4,4,4,8};
		static int[] workarray = new int[4];
		static int[] idx = new int[4];

        /// <summary>
        /// Find minimum and maximum value from specified array
        /// </summary>
        /// <param name="arr">target array to find min/max value</param>
        /// <param name="imin">[out] index of minimum element in the array</param>
        /// <param name="imax">[out] index of maximum element in the array</param>
        /// <returns>the difference between maximum and minimum values</returns>
        static public int GetMinMax(int[] arr, out int imin, out int imax) {
            imin = 0;
            imax = 0;
            for (int i = 1; i < arr.Length; i++) {
                if (arr[imin] >= arr[i]) { imin = i; }
                if (arr[imax] < arr[i]) { imax = i; }
            }
            return arr[imax] - arr[imin];            
        }

		/// <summary>
		/// {NZ̒_Kp^[ɍ悤ɕ␳		/// 
		/// </summary>
		/// <param name="vertices"></param>
		/// <returns>_̍ŏlԂ</returns>
		static public int CorrectCellVertices(ref int[] vertices)
		{
			// MEMO:min܂maxƈقȂĺASmedԒlƂׂ
			vertices.CopyTo(workarray,0);
			for( int i=0; i<4; i++)
				idx[i] = i;
			Array.Sort(workarray,idx);
			int minimum = workarray[0];
			for( int i=0; i<4; i++){
				workarray[i]-=minimum;
				vertices[i]-=minimum;
			}

			// SĂ̖ʂ
			if(workarray[0]==workarray[3])
				return minimum;
			// őlƍŏl̍
			int gap = workarray[3]-workarray[0];
			// őlƍŏl̍0,1,2,4,8̂ꂩɏk␳
			if(gap>8) gap = 8;
			else gap = vtx_step[gap];

			int tmp;
			// O_ŏl
			if(workarray[0]==workarray[2])
			{
				vertices[idx[3]]=workarray[0]+gap;
				return minimum;
			}
			// O_ől
			if(workarray[1]==workarray[3])
			{
				vertices[idx[0]]=workarray[3]-gap;
				return minimum;
			}
			// _ŏl
			if(workarray[0]==workarray[1])
			{
				// _ŏl_ől
				if(workarray[2]==workarray[3])
				{
					// ̒_ɂ
					int org = (workarray[1]+workarray[2]-gap)>>1;
					vertices[idx[0]]=vertices[idx[1]]=org;
					vertices[idx[2]]=vertices[idx[3]]=org+gap;
					return minimum;
				}
				// _ŏl_݂̂ől
				else
				{
					// ŏlɂ	
					tmp = workarray[0]+gap;
					vertices[idx[3]] = tmp;
					if( tmp < workarray[2] )
						vertices[idx[2]] = tmp;
					else
						vertices[idx[2]]=workarray[0]+(gap>>1);
					return minimum;
				}
			}
			// _ől_݂̂ŏl
			if(workarray[2]==workarray[3])
			{
				// őlɂ
				tmp =workarray[3]-gap;
				vertices[idx[0]] = tmp;
				if( workarray[1] < tmp )
					vertices[idx[1]] = tmp;
				else
					vertices[idx[1]]=vertices[idx[0]]+(gap>>1);
				return minimum;
			}
			else 
			{
				// őlƍŏle_Â
				// ̒_ɂ
				int org = (workarray[0]+workarray[3]-gap)>>1;
				vertices[idx[0]]=org;
				vertices[idx[3]]=org+gap;
				tmp = org+(gap>>1);
				if(workarray[1]<org)
					vertices[idx[1]] = org;
				else
					vertices[idx[1]] = tmp;
				if(vertices[idx[3]]<workarray[2])
					vertices[idx[2]]=vertices[idx[3]];
				else
					vertices[idx[2]] = tmp;
				//return minimum;
			}
			return minimum;
		}
	}
}
