using System;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using nft.ui.mainframe;
using nft.framework.drawing;
using nft.ui.command;

namespace nft.contributions.ui
{
	/// <summary>
	/// CtbMenuItem ̊Tv̐łB
	/// </summary>
	public class CtbCommandUI : Contribution
	{
        private static readonly Type singleDefault = typeof(TriggerCommandUI);
		public readonly string location;
		protected readonly string after = null;
		protected readonly string before = null;

		/// <summary>
		/// Contributes a menu and submenu items to mainmenu.
		/// 
		/// This contribution can add several items at once.
		/// </summary>
        public CtbCommandUI(Plugin p, XmlElement e)
            : base(p, e) 
		{
            object[] args = new object[] { this, e };
            CommandUI cui = (CommandUI)PluginUtil.loadObjectFromManifest(e, args, singleDefault);
            XmlNode ndSetup = e.SelectSingleNode("setup");
            if (ndSetup != null) {
                XmlElement ndMenu = (XmlElement)ndSetup.SelectSingleNode("menu-item");
                ConfirmIDAttribute(ndMenu);
                XmlElement ndTool = (XmlElement)ndSetup.SelectSingleNode("tool-item");
                ConfirmIDAttribute(ndTool);
                CommandPathHint hint = new CommandPathHint(ndMenu);
                CommandPathHint hint2 = new CommandPathHint(ndTool);
                CommandManager.TheInstance.RegisterCommand(this, cui, hint, hint2);
            }
		}

        protected void ConfirmIDAttribute(XmlElement e) {
            XmlAttribute a = e.Attributes["id"];
            if (a == null) {
                XmlUtil.SetAttribute(e, "id", this.id);
            }
        }
	}
}
