using System;
using System.Drawing;

namespace nft.framework.drawing
{
	/// <summary>
	/// ISurface IDrawable`悷LpX
	/// </summary>
	public interface ISurface : IDrawable
	{
		PixelColorMode PixelColorMode {get;}
		Color ColorKey { get; set; }
		Size Size { get; }
		/// <summary>
		/// Clear the surface region with a specified color.
		/// </summary>
		/// <param name="region"></param>
		/// <param name="fill"></param>
		void Clear(Rectangle region, Color fill);
		void Clear(Color fill);
        void BitBlt(ISurface source, DrawParams dp);
        void BitBlt(ISurface source, DrawParams dp, IPixelFilter filter);
        void BitBlt(ISurface source, DrawParams dp, ISurfaceDrawer drawer);
		bool HitTest(int x, int y );
		Bitmap CreateBitmap(PixelColorMode mode);
        bool IsSurfaceLost { get; }
	}

}
