using System;
using System.Collections;
using System.Drawing;
using System.Windows.Forms;
using nft.ui.command;

namespace nft.ui.mainframe
{
	public delegate void FileDroppedHandler( string filename );
	/// <summary>
	/// IMainFrame ̊Tv̐łB
	/// </summary>
	public interface IBarHostFrame
	{                
        event EventHandler<EventArgs> ActiveViewChanged;
        event EventHandler<EventArgs> ActiveSubformChanged;

        void AddFileDroppedHandler(FileDroppedHandler handler);

        /// <summary>
        /// Create ToolBarButton.
        /// if the bar specified by cui.Parent is not found, create new one.
        /// </summary>
        /// <param name="cui"></param>
        /// <param name="toolbar"></param>
        void AddToolButton(CommandUI cui, CommandPathHint toolbar);

		/// <summary>
        /// Create MenuItem.
        /// </summary>
		/// <param name="cui">the source command ui</param>
		/// <param name="pathHint">menu path hint to locate menu item.</param>
        void AddMenuItem(CommandUI cui, CommandPathHint pathHint);

		/// <summary>
		/// Set ICommandEntity as a click event handler of specified tool button.
		/// </summary>
		/// <param name="entity"></param>
		/// <param name="barname"></param>
		/// <param name="bid"></param>
		/// <returns></returns>
		CommandUI_Old SetToolButtonCommand( string cmdID, ICommandEntity_Old entity, string barname, string bid );

		/// <summary>
		/// Set ICommandEntity as a click event handler of specified menu item.
		/// </summary>
		/// <param name="entity"></param>
		/// <param name="path"></param>
		/// <returns></returns>
		CommandUI_Old SetMenuCommand( string cmdID, ICommandEntity_Old entity, string path );

		/// <summary>
		/// Register the form as MDI child frame of MainFrame.
		/// </summary>
		/// <param name="frame"></param>
        void AddView(String caption, Control content);

        Control ActiveView { get; set; }

		Form[] MdiChildren{get;}

        void SetStatusText(string txt);
    }
}
