﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using XNua;
using FrkEffectLib.Primitive;

//エフェクトデータ（luaファイル保持用）

namespace FrkEffectLib
{
    public class FrkLibEffectData
    {
        //参照先データ
        LuaClosure pData;
        //パス
        public String Path;

        //参照データのパスキャッシュ(GC対策)
        Dictionary<string, string> texPathCache = new Dictionary<string, string>();
        Dictionary<string, string> scriptPathCache = new Dictionary<string, string>();
        public Dictionary<string, string> TexPathCache { get { return texPathCache; } }
        public Dictionary<string, string> ScriptPathCache { get { return scriptPathCache; } }

        object[] CallArgs = new object[4];
        Object[] ret = new object[1];
        //コンストラクタ
        public FrkLibEffectData(String path)
        {
            Path = path;
            pData = FrkLibXnuaManager.Load(path);
        }
        //スクリプト実行
        public bool Play(FrkLibEffectObj mom)
        {
            //データが無かったら無視
            if (pData == null)
            {
                return false;
            }
            //実行処理
            CallArgs[0] = mom;
            CallArgs[1] = mom.GetCreateParam();
            CallArgs[2] = FrkMath.GetMath();
            CallArgs[3] = FrkLibEffectManager.GetInstance().GetUserProc();
            ret[0] = null;
            int result = pData.Call(CallArgs, ret);
            //Object[] ret = pData.Call(new Object[] { mom,mom.GetCreateParam(),FrkMath.GetMath() });

            if (result == 0)
                return true;
            else
                return (bool)ret[0];
        }
    }
}
