﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;
using FrkEffectLib.Primitive;

namespace FrkEffectLib
{
    //エフェクトマネージャークラス
    //シングルトン

    //管理、描画リストの種類
    public enum DRAWLAYER
    {
        ALPHA,
        ADD,
        DISP_ALPHA,
        DISP_ADD,
        SYSTEM,
        MAX,
    };
    public enum OBJTYPE
    {
        NODE,
        QUAD,
        LINE,
        DISC,
        WAVE,
        SPHERE,
        MAX,
    };
    public class FrkLibEffectManager
    {
        //実体のポインタ
        static private FrkLibEffectManager Instance;
        //実体の取得関数
        static public FrkLibEffectManager GetInstance()
        {
            if (Instance == null)
            {
                Instance = new FrkLibEffectManager();
            }
            return Instance;
        }
        //コンストラクタ(通常では呼び出せない
        private FrkLibEffectManager()
        {
            //初期化フラグをfalse
            bInit = false;
        }

        //---非公開メンバ---//
        //初期化フラグ
        bool bInit;
        //コンテンツマネージャへのポインタ
        public ContentManager Content;
        //デバイスのポインタ
        private GraphicsDevice GrfDev;
        //Matrixは値型。コピーが重いので公開メンバにして直アクセス(Wilfrem)
        //ビュー行列
        public Matrix View;
        //プロジェクション行列
        public Matrix Proj;
        //カメラの座標
        public Vector3 CamPos;
       
        //エフェクトオブジェリスト　キー用変数
        private uint nNowID;

        //オブジェクト動作用リスト
        List<FrkLibEffectObj>[] ObjList = new List<FrkLibEffectObj>[(int)DRAWLAYER.MAX];
        //オブジェクト管理用リスト
        Dictionary<uint, FrkLibEffectObj> ObjDataBase = new Dictionary<uint, FrkLibEffectObj>(256);

        //アスペクト比
        private float fAspect;
        //ベーシックエフェクト
        private BasicEffect Effect;
        //頂点定義
        private VertexDeclaration vertexDeclaration;

        //プリミティブプール
        private List<FrkLibEffectObj>[] Pool = new List<FrkLibEffectObj>[(int)OBJTYPE.MAX];
        //頂点プール
        private List<VertexPositionColorTexture> vertexPool = new List<VertexPositionColorTexture>();

        //サウンドマネージャーポインタ
        private FrkLibSoundManagerInterface pSoundManager;
        //ユーザ定義機能クラスポインタ
        private UserProcInterface pUserProc;
        //オブジェ比較用
        ObjComparer ObjComp = new ObjComparer();
        //lilファイルの優先読み込み設定
        bool bFirstLil = true;

        //---公開関数---//
        
        //lilファイルの優先読み込み設定の変更
        public void SetFirstLil(bool b)
        {
            bFirstLil = b;
        }
        public bool GetFirstLil()
        {
            return bFirstLil;
        }

        //行列取得
        /*public Matrix GetView()
        {
            return View;
        }
        public Matrix GetProj()
        {
            return Proj;
        }*/

        //現在動作している総エフェクト数を返す
        public int GetEffectNum()
        {
            return ObjDataBase.Count;
        }
        //カメラ座標取得関数
        public Vector3 GetCamPos()
        {
            return CamPos;
        }
        //エフェクト取得
        public BasicEffect GetEffect()
        {
            return Effect;
        }
        //頂点定義取得
        public VertexDeclaration GetVertexDeclaration()
        {
            return vertexDeclaration;
        }
        //頂点取得
        public VertexPositionColorTexture[] GetVertexPool(int num)
        {
            //プールが足りなかったら追加
            if (vertexPool.Count < num)
            {
                int add = num - vertexPool.Count;
                if (add < 0)
                    add = 0;
                AddVertexPool((uint)add);
            }
            return vertexPool.ToArray();
        }

        //初期化処理
        //出力：成功時true 失敗時falseを返す
        //Note：content==nullを指定するとコンテンツマネージャーを使わずにスクリプトの相対パスで読みに行く
        public bool Init(ContentManager content,GraphicsDevice dev)
        {
            bool bResult = true;
            if (bInit == false)
            {
                Content = content;
                GrfDev = dev;
                //xnua初期化
                //FrkLibXnuaManager.Init();

                //データベースの初期化
                ObjDataBase.Clear();

                //オブジェリストの作成
                for (int i = 0; i < (int)DRAWLAYER.MAX; i++)
                {
                    ObjList[i] = new List<FrkLibEffectObj>(256);
                }

                //オブジェプールの作成(初期値は32個）
                for (int i = 0; i < (int)OBJTYPE.MAX; i++)
                {
                    Pool[i] = new List<FrkLibEffectObj>(256);
                    AddPool((OBJTYPE)i, 32);
                }
                //頂点プールの作成（初期値は256個）
                AddVertexPool(256);

                //FrkObject用キー管理用変数の初期化
                nNowID = 1;

                //アスペクト比を計算
                fAspect =
                    (float)GrfDev.Viewport.Width /
                    (float)GrfDev.Viewport.Height;

                //ベーしくエフェクトの作成
                Effect = new BasicEffect(GrfDev, null);
                // 頂点データ定義を作成
                vertexDeclaration = new VertexDeclaration(
                    GrfDev, VertexPositionColorTexture.VertexElements);

                //サウンドマネージャーにデフォルトのクラスをセット
                pSoundManager = new FrkLibSoundManager();
                //ユーザー定義クラスにデフォルトのクラスをセット
                pUserProc = new UserProcBase();
            }
            else
            {
                bResult = false;
            }

            return bResult;
        }
        public void AddPool(OBJTYPE tgt, uint num)
        {
            for (int i = 0; i < num; i++)
            {
                switch(tgt)
                {
                    case OBJTYPE.NODE:
                        Pool[(int)tgt].Add(new FrkLibEffectObj());
                        break;
                    case OBJTYPE.QUAD:
                        Pool[(int)tgt].Add(new FrkLibEffectQuad());
                        break;
                    case OBJTYPE.LINE:
                        Pool[(int)tgt].Add(new FrkLibEffectLine());
                        break;
                    case OBJTYPE.DISC:
                        Pool[(int)tgt].Add(new FrkLibEffectDisc());
                        break;
                    case OBJTYPE.WAVE:
                        Pool[(int)tgt].Add(new FrkLibEffectWave());
                        break;
                    case OBJTYPE.SPHERE:
                        Pool[(int)tgt].Add(new FrkLibEffectObj());
                        break;
                }
            }
        }
        public void AddVertexPool(uint num)
        {
            for (int i = 0; i < num; i++)
            {
                vertexPool.Add(new VertexPositionColorTexture());
            }
        }
        public FrkLibSoundManagerInterface GetSoundManager()
        {
            return pSoundManager;
        }
        public void SetSoundManager(FrkLibSoundManagerInterface smg)
        {
            pSoundManager = smg;
        }
        public UserProcInterface GetUserProc()
        {
            return pUserProc;
        }
        public void SetUserProc(UserProcInterface p)
        {
            pUserProc = p;
        }

        //更新処理
        //入力：VIEW行列、PROJ行列
        //出力：成功時true 失敗時falseを返す
        //専用変数
        List<FrkLibEffectObj> DelList = new List<FrkLibEffectObj>(256);
        List<FrkLibEffectObj> DelBookingList = new List<FrkLibEffectObj>(256);
        public bool Update(ref Matrix camview,ref Matrix camproj)
        {
            View = camview;
            Proj = camproj;
            //カメラ座標を保存
            Matrix invvie = Matrix.Invert(View);
            CamPos = invvie.Translation;

            //Objectを更新
            for (int i = 0; i < (int)DRAWLAYER.MAX; i++)
            {
                for (int j = 0; j < ObjList[i].Count; j++)
                {
                    FrkLibEffectObj obj = ObjList[i].ElementAt(j);
                    if (obj.Main())
                    {
                        //削除予約リストにキーを登録
                        DelBookingList.Add(obj);
                    }
                }
                for (int j = 0; j < DelBookingList.Count; j++)
                {
                    FrkLibEffectObj obj = DelBookingList[j];
                    ObjList[i].Remove(obj);
                    if (obj.End())
                    {
                        //削除リストにキーを登録
                        DelList.Add(obj);
                    }
                }
                for (int j = 0; j < DelList.Count; j++)
                {
                    FrkLibEffectObj obj = DelList[j];
                    //オブジェリストから消去
                    ObjList[i].Remove(obj);
                    //データベースから消去
                    ObjDataBase.Remove(obj.ID);
                    //削除予約リストから消去
                    DelBookingList.Remove(obj);
                    //削除リストのオブジェをプールに返す
                    RemovePool(obj.GetEffectType(), obj);
                }
                DelList.Clear();

            }
            return true;
        }

        //全リスト描画処理
        //入力：描画リスト番号
        //出力：成功時true 失敗時falseを返す
        public bool Draw()
        {
            //Objectを更新
            for (int i = 0; i < (int)DRAWLAYER.MAX; i++)
            {
                Draw(i);
            }
            return true;
        }

        //単一リスト描画処理
        //入力：描画リスト番号
        //出力：成功時true 失敗時falseを返す
        public bool Draw(int id)
        {
            SetBlend((DRAWLAYER)id);
            if (id == (int)DRAWLAYER.ALPHA)
            {
                //半透明オブジェの場合、Zソート
                ObjList[id].Sort(ObjComp);
            }
            for (int i = 0; i < ObjList[id].Count; i++)
            {
                FrkLibEffectObj obj = ObjList[id].ElementAt(i);
                obj.Draw();
            }
            return true;
        }
        //合成設定
        public void SetBlend(DRAWLAYER id)
        {
            //アルファブレンドを有効にする
            GrfDev.RenderState.AlphaBlendEnable = true;
            //テクスチャループ設定
            GrfDev.SamplerStates[0].AddressU = TextureAddressMode.Wrap;
            GrfDev.SamplerStates[0].AddressV = TextureAddressMode.Wrap;

            switch (id)
            {
                //半透明
                case DRAWLAYER.ALPHA:
                    //アルファブレンドの合成方法を設定する
                    GrfDev.RenderState.SourceBlend = Blend.SourceAlpha;
                    GrfDev.RenderState.DestinationBlend = Blend.InverseSourceAlpha;
                    //Zバッファを有効にする
                    GrfDev.RenderState.DepthBufferEnable = true;
                    GrfDev.RenderState.DepthBufferWriteEnable = false;
                    break;
                //加算減算
                case DRAWLAYER.ADD:
                    //アルファブレンドの合成方法を設定する
                    GrfDev.RenderState.SourceBlend = Blend.SourceAlpha;
                    GrfDev.RenderState.DestinationBlend = Blend.One;
                    //Zバッファを有効にする
                    GrfDev.RenderState.DepthBufferEnable = true;
                    GrfDev.RenderState.DepthBufferWriteEnable = false;
                    break;
                //ディスプレイ用半透明
                case DRAWLAYER.DISP_ALPHA:
                    //アルファブレンドの合成方法を設定する
                    GrfDev.RenderState.SourceBlend = Blend.SourceAlpha;
                    GrfDev.RenderState.DestinationBlend = Blend.InverseSourceAlpha;
                    //Zバッファを有効にする
                    GrfDev.RenderState.DepthBufferEnable = true;
                    GrfDev.RenderState.DepthBufferWriteEnable = false;
                    break;
                //ディスプレイ用加算
                case DRAWLAYER.DISP_ADD:
                    //アルファブレンドの合成方法を設定する
                    GrfDev.RenderState.SourceBlend = Blend.SourceAlpha;
                    GrfDev.RenderState.DestinationBlend = Blend.InverseSourceAlpha;
                    //Zバッファを有効にする
                    GrfDev.RenderState.DepthBufferEnable = true;
                    GrfDev.RenderState.DepthBufferWriteEnable = false;
                    break;
                //システム用（半透明）
                case DRAWLAYER.SYSTEM:
                    break;

            }
        }

        //FRKデータ読み込み
        //入力：ファイルパス
        //出力：成功時ファイルへのポインタ 失敗時nullを返す
        public FrkLibEffectData LoadFrkData(String path)
        {
            FrkLibEffectData ret = new FrkLibEffectData(path);
            return ret;
        }

        //エフェクトの作成（ユーザー用）
        //入力：FrkDataポインタ 座標 スケール クオータニオン　色
        //出力：成功時生成したエフェクトのID　失敗時0
        public uint CreateEffect(FrkLibEffectData p, Vector3 pos, Vector3 scale, Quaternion qua, Color col)
        {
            return CreateEffect(null,p,OBJTYPE.NODE, pos, scale, qua, col);
        }
        //エフェクトの作成（子オブジェ生成用
        public uint CreateEffect(EffectParam param, FrkLibEffectData p, OBJTYPE type, Vector3 pos, Vector3 scale, Quaternion qua, Color col)
        {
            DRAWLAYER tgt = DRAWLAYER.SYSTEM;
            //プールにオブジェが存在しなかった場合、拡張
            if (Pool[(int)type].Count == 0)
            {
                AddPool(type, 1);
            }

            uint ret = nNowID;
            
            //プールから該当種類を取得
            FrkLibEffectObj obj = Pool[(int)type].First();
            if (param != null)
            {
                tgt = param.DrawLayer;
            }
            ObjList[(int)tgt].Insert(0,obj);
            ObjDataBase.Add(ret,obj);
            Pool[(int)type].Remove(obj);
            
            //オブジェの初期化
            obj.Init(p, nNowID);
           
            if (param == null)
            {
                //子オブジェじゃないとき
                obj.GetParam().Pos = pos;
                obj.GetParam().Scale = scale;
                obj.DefQua = qua;
                obj.GetParam().Col = col;
            }
            else
            {
                //子オブジェなら親の指定した値をコピー
                obj.GetParam().Copy(param);
                obj.GetParam().Scale = scale;
            }

            nNowID++;
            return ret;
        }

        //エフェクトへのアクセス
        //入力：エフェクトのID　座標　スケール　クオータニオン　色
        //出力：成功時true 失敗時false
        public bool AccessEffect(uint id, Vector3 pos, Vector3 scale, Quaternion qua, Color col)
        {
            //キーの存在チェック
            if (!ObjDataBase.ContainsKey(id))
            {
                //存在しないので失敗を返す
                return false;
            }
            else
            {
                //パラメータを設定
                ObjDataBase[id].GetParam().Pos = pos;
                ObjDataBase[id].GetParam().Scale = scale;
                ObjDataBase[id].GetParam().Qua = qua;
                ObjDataBase[id].GetParam().Col = col;
                //成功を返す
                return true;
            }
        }
        //エフェクトの取得
        public FrkLibEffectObj GetObj(uint id)
        {
            //キーの存在チェック
            if (!ObjDataBase.ContainsKey(id))
            {
                //存在しないのでnullを返す
                return null;
            }
            FrkLibEffectObj ret;
            ObjDataBase.TryGetValue(id, out ret);
            return ret;
        }
        //エフェクトの消去
        public void Delete(uint id)
        {
            ObjDataBase[id].SetKill(true);
        }
        //エフェクトの全消去
        public void AllDelete()
        {
            for (int i = 0; i < (int)DRAWLAYER.MAX; i++)
            {
                for (int j = 0; j < ObjList[i].Count; j++)
                {
                    FrkLibEffectObj obj = ObjList[i].ElementAt(j);
                    //削除リストにキーを登録
                    DelList.Add(obj);
                    //データベースから消去
                    ObjDataBase.Remove(obj.ID);
                }
                for (int j = 0; j < DelList.Count; j++)
                {
                    FrkLibEffectObj obj = DelList[j];
                    //オブジェリストから消去
                    ObjList[i].Remove(obj);
                    //削除リストのオブジェをプールに返す
                    RemovePool(obj.GetEffectType(), obj);
                }
                ObjDataBase.Clear();
                DelBookingList.Clear();
                DelList.Clear();
            }
        }
        //エフェクトデータも全消去
        public void AllDeleteData()
        {
            FrkLibXnuaManager.ClearCache();
            EffectParam.ClearCache();
        }
        //プールに返す
        public void RemovePool(int type, FrkLibEffectObj obj)
        {
            Pool[type].Add(obj);
        }

        //グラフィックデバイスの取得
        public GraphicsDevice GetGrfDev()
        {
            return GrfDev;
        }

        //アスペクト比の取得
        public float GetAspect()
        {
            return fAspect;
        }
    }
}
