﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using XNua;
using System.Reflection;
using FrkEffectLib.Primitive;

//xnua管理クラス
//スタティックな関数群

namespace FrkEffectLib
{
    public delegate void NeedCompileDelegate(string luaFile);
    public class FrkLibXnuaManager
    {
        //Lilファイル優先フラグ
        //public static bool bLilFirst;
        /// <summary>
        /// コンパイルが必要なときに呼ばれるイベント
        /// </summary>
        public static event NeedCompileDelegate NeedCompile;

        //ロード済みxnuaファイル
        private static Dictionary<String, LuaClosure> LuaData = new Dictionary<string,LuaClosure>();

        public static LuaState LState = new LuaState();

        public static void ClearCache()
        {
            LuaData.Clear();
        }
        /// <summary>
        /// Lilをロード
        /// </summary>
        /// <param name="path">.lilファイルのパス</param>
        /// <returns></returns>
        public static LuaClosure Load(string path)
        {
            //FrkLibEffectManager.GetInstance().game.Content.Load<>(path);

            LuaClosure cl;
            Assembly assembly;
            //pathから拡張子を覗く
            path=Path.Combine(Path.GetDirectoryName(path),Path.GetFileNameWithoutExtension(path));
            string luaFile = path + ".lua";
            string outpath = path+".lil";
            //コンテンツマネージャーがあるならそれ基準にする
            if (FrkLibEffectManager.GetInstance().Content != null)
                outpath = Path.Combine(FrkLibEffectManager.GetInstance().Content.RootDirectory, outpath);

            //読み込み済みがあればそれを使用
            if (LuaData.TryGetValue(path, out cl))
            {
                return cl;
            }
            //lilファイル優先読み込みフラグを確認
            if (!FrkEffectLib.FrkLibEffectManager.GetInstance().GetFirstLil())
            {
                //フラグが立っていなかった場合、強制的にluaをコンパイル
                if (NeedCompile != null && File.Exists(luaFile))
                    NeedCompile(luaFile);
            }
            //// アセンブリ（.lil）のロードを一度試す
            string scriptName = System.IO.Path.GetFileNameWithoutExtension(outpath);
#if false//.lilが無いときはコンパイルを行わない
            if (!bLilFirst || !System.IO.File.Exists(outpath))
            {
                //.lilファイルが無かったのでコンパイル
                // コンパイル＆.lil 作成
                XNua.LuaParser.Parser parser = new XNua.LuaParser.Parser();
                XNua.LuaParser.ProtoWrapper proto = parser.ParseFile(luaFile);
                System.IO.MemoryStream memStream = new System.IO.MemoryStream(proto.ToString().Length);
                parser.WriteByteCode(proto, memStream);
                memStream.Position = 0;
                parser.ByteCodeToIL(memStream, outpath);
            }
#endif
            if (!System.IO.File.Exists(outpath))
            {
                if (NeedCompile != null && File.Exists(luaFile))
                    NeedCompile(luaFile);
                if (!System.IO.File.Exists(outpath))
                    throw new FileNotFoundException("ファイル" + outpath + "がみつかりません");
            }
            // アセンブリ（.lil）のロード
            assembly = Assembly.LoadFrom(outpath);

            // 関数の実体定義
            Type mainClosure = assembly.GetType(scriptName + ".MainProc");
            ConstructorInfo ctor = mainClosure.GetConstructor(new Type[] { typeof(LuaReference) });
            cl = (LuaClosure)ctor.Invoke(new Object[] { LState.Globals });

            //読み込み成功
            LuaData.Add(path, cl);

            return cl;
        }
        
    }
}

