﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace FrkEffectLib
{
    class FrkMath
    {
        static public FrkMath Instance;
        static public FrkMath GetMath()
        {
            if (Instance == null)
                Instance = new FrkMath();
            return Instance;
        }
        Random rand;
        public FrkMath()
        {
            rand = new Random();
        }
        //ランダム
        public float random()
        {
            return random(0.0f,1.0f);
        }
        public float random(float max)
        {
            return random(0, max);
        }
        public float random(float min,float max)
        {
            return (float)rand.NextDouble() * (max - min) + min;
        }
        //int型に変換
        public int floor(float num)
        {
            return (int)num;
        }
        //Cos
        public float cos(float rad)
        {
            return (float)Math.Cos((float)rad);   
        }
        //Sin
        public float sin(float rad)
        {
            return (float)Math.Sin((float)rad);
        }
        //toRad
        public float rad(float deg)
        {
            return MathHelper.ToRadians(deg);
        }
        //toDeg
        public float deg(float rad)
        {
            return MathHelper.ToDegrees(rad);
        }      
        //atan2
        public float atan2(float y, float x)
        {
            return (float)Math.Atan2(y, x);
        }
        public int par(int num, int par)
        {
            return num % par;
        }
        

    }
}
