﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;


namespace FrkEffectLib.Primitive
{
    class FrkLibEffectLine : FrkLibEffectObj
    {
        public Vector3[] PosBuf;
        public Quaternion[] QuaternionBuf;
        public int SplitNum;

        public override void UniqueInit()
        {
            //Param.Qua = Quaternion.CreateFromYawPitchRoll(Param.Rot.X, Param.Rot.Y, Param.Rot.Z);
            PosBuf = new Vector3[Param.SplitNum];
            QuaternionBuf = new Quaternion[Param.SplitNum];
            SplitNum = (int)Param.SplitNum;
        }
        protected override void UniqueMain()
        {
            //初期化
            if (nTime <= 1)
            {
                for (int i = 0; i < SplitNum; i++)
                {
                    PosBuf[i] = matLast.Translation;
                    QuaternionBuf[i] = Quaternion.CreateFromRotationMatrix(matRotLast);
                }
            }
            //座標履歴の更新
            for (int i = SplitNum - 1; i > 0; i--)
            {
                PosBuf[i] = PosBuf[i - 1];
                QuaternionBuf[i] = QuaternionBuf[i - 1];
            }
            PosBuf[0] = matLast.Translation;
            QuaternionBuf[0] = Quaternion.CreateFromRotationMatrix(matRotLast);
        }

        public override void UniqueDraw()
        {
            FrkLibEffectManager mng = FrkLibEffectManager.GetInstance();
            int ver_num = SplitNum * 2;
            VertexPositionColorTexture[] vertices = FrkLibEffectManager.GetInstance().GetVertexPool(ver_num);

            float u = Param.UVPos.X;
            float v = Param.UVPos.Y;
            float us = Param.UVSize.X;
            float vs = Param.UVSize.Y;
            float fMinScale = Param.InRatio;
            float fAlphaFirst = Param.Alpha1;
            float fAlphaEnd = Param.Alpha2;
            int LineLength = SplitNum;

            Matrix invvie = Matrix.Invert(mng.View);
            Vector3 CamPos = invvie.Translation;

            for (int i = 0; i < SplitNum; i++)
            {
                //横を計算する
                Vector3 Side = new Vector3();

                Vector3 aim_camera = (CamPos - PosBuf[i]);
                aim_camera.Normalize();

                Vector3 tangent;
                if (i == 0) tangent = PosBuf[1] - PosBuf[0];    // 始点の場合
                else if (i == LineLength - 1) tangent = PosBuf[i] - PosBuf[i - 1];  // 終点の場合
                else tangent = PosBuf[i + 1] - PosBuf[i - 1];
                tangent.Normalize();
                
                //ビルボード計算
                if (Param.BillBoard)
                {
                    Vector3 vertical = Vector3.Cross(tangent, aim_camera);
                    vertical.Normalize();
                    Side = vertical * (1.0f / 2); // 左右2方向に向かうので/2しておく
                }
                else
                {
                    Vector3 vertical = Vector3.Cross(tangent, (Matrix.CreateFromQuaternion(QuaternionBuf[i])) .Up);
                    vertical.Normalize();
                    Side = vertical * (1.0f / 2); // 左右2方向に向かうので/2しておく
                }
                //拡縮
                Side = Vector3.Transform(Side, matScaleLast);
                vertices[i * 2].Position = PosBuf[i];
                vertices[i * 2].Position += Side;
                vertices[i * 2].TextureCoordinate.X = u + ((float)i / (float)LineLength) * us;
                vertices[i * 2].TextureCoordinate.Y = v;
                vertices[i * 2 + 1].Position = PosBuf[i];
                vertices[i * 2 + 1].Position -= Side;
                vertices[i * 2 + 1].TextureCoordinate.X = u + ((float)i / (float)LineLength) * us;
                vertices[i * 2 + 1].TextureCoordinate.Y = v + vs;

                float def = 1.0f - ((float)i / (float)LineLength);

                float w = fAlphaFirst - fAlphaEnd;
                w *= def;
                w += fAlphaEnd;

                vertices[i * 2].Color = Param.Col;
                vertices[i * 2].Color.A = (byte)(w * 255.0f);
                vertices[i * 2 + 1].Color = Param.Col;
                vertices[i * 2 + 1].Color.A = (byte)(w * 255.0f);
            }
            GraphicsDevice GrfDevice = mng.GetGrfDev();
            BasicEffect basicEffect = mng.GetEffect();

            // エフェクトの使用を開始します
            basicEffect.Begin();

            //基本的なポリラインの描画
            // 描画する頂点データの定義を設定
            GrfDevice.VertexDeclaration = mng.GetVertexDeclaration();

            // パスの数だけ繰り替えし描画 (BasicEffect は通常１回)
            for (int i = 0; i < basicEffect.CurrentTechnique.Passes.Count; i++)
            {
                EffectPass pass = basicEffect.CurrentTechnique.Passes[i];
                // パスの開始
                pass.Begin();

                if (Param.Tex != null)
                {
                    basicEffect.TextureEnabled = true;
                    basicEffect.Texture = Param.Tex;
                }
                else
                {
                    basicEffect.Texture = null;
                    basicEffect.TextureEnabled = false;
                }
                basicEffect.LightingEnabled = false;
                basicEffect.VertexColorEnabled = true;

                // ポリゴンを描画する

                GrfDevice.RenderState.CullMode = CullMode.None;
                GrfDevice.RenderState.DepthBufferEnable = true;
                GrfDevice.RenderState.DepthBufferWriteEnable = false;

                // ビュー座標変換行列
                //Matrix view = mng.GetView();

                // 射影変換行列
                //Matrix projection = mng.GetProj();

                basicEffect.View = mng.View;

                basicEffect.World = Matrix.Identity;
                basicEffect.Projection = mng.Proj;

                basicEffect.Alpha = 1.0f;
                basicEffect.CommitChanges();


                GrfDevice.DrawUserPrimitives<VertexPositionColorTexture>(
                    PrimitiveType.TriangleStrip,
                    vertices,
                    0,
                    ver_num - 2
                );


                // パスの終了
                pass.End();
            }

            // エフェクトの使用を終了する
            basicEffect.End();
        }
    }
}
