﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace FrkEffectLib.Primitive
{
    class FrkLibEffectQuad : FrkLibEffectObj
    {
        public override void UniqueDraw()
        {
            //1フレーム目は計算用なので描画しない
            if (nTime <= 1)
                return;
            VertexPositionColorTexture[] vertices = FrkLibEffectManager.GetInstance().GetVertexPool(4);

            vertices[0].Position = new Vector3(-0.5f, -0.5f, 0);
            vertices[0].TextureCoordinate.X = Param.UVPos.X;
            vertices[0].TextureCoordinate.Y = Param.UVPos.Y;
            vertices[1].Position = new Vector3(0.5f, -0.5f, 0);
            vertices[1].TextureCoordinate.X = Param.UVPos.X + Param.UVSize.X;
            vertices[1].TextureCoordinate.Y = Param.UVPos.Y;
            vertices[2].Position = new Vector3(-0.5f, 0.5f, 0);
            vertices[2].TextureCoordinate.X = Param.UVPos.X;
            vertices[2].TextureCoordinate.Y = Param.UVPos.Y + Param.UVSize.Y;
            vertices[3].Position = new Vector3(0.5f, 0.5f, 0);
            vertices[3].TextureCoordinate.X = Param.UVPos.X + Param.UVSize.X;
            vertices[3].TextureCoordinate.Y = Param.UVPos.Y + Param.UVSize.Y;

            for (int i = 0; i < 4; i++)
            {
                vertices[i].Color = new Color(255, 255, 255, Param.Alpha1);
            }
            FrkLibEffectManager mng = FrkLibEffectManager.GetInstance();
            GraphicsDevice GrfDevice = mng.GetGrfDev();
            BasicEffect basicEffect = mng.GetEffect();

            // エフェクトの使用を開始します
            basicEffect.Begin();

            //基本的なポリラインの描画
            // 描画する頂点データの定義を設定
            GrfDevice.VertexDeclaration = mng.GetVertexDeclaration();

            // パスの数だけ繰り替えし描画 (BasicEffect は通常１回)
            for (int i = 0; i < basicEffect.CurrentTechnique.Passes.Count; i++)
            {
                EffectPass pass = basicEffect.CurrentTechnique.Passes[i];
                // パスの開始
                pass.Begin();

                if (Param.Tex != null)
                {
                    basicEffect.TextureEnabled = true;
                    basicEffect.Texture = Param.Tex;
                }
                basicEffect.LightingEnabled = false;
                basicEffect.VertexColorEnabled = true;

                // ポリゴンを描画する

                GrfDevice.RenderState.CullMode = CullMode.None;
                GrfDevice.RenderState.DepthBufferEnable = true;
                GrfDevice.RenderState.DepthBufferWriteEnable = false;

                // ビュー座標変換行列
                
                // 射影変換行列
                //Matrix projection = mng.GetProj();

                basicEffect.View = mng.View;

                Matrix drawmat;
                //ビルボードの場合の処理
                if (Param.BillBoard)
                {
                    Matrix view = mng.View;
                    view.Translation = Vector3.Zero;
                    Vector3 wp = matLast.Translation;
                    Matrix inv = Matrix.Invert(view);
                    drawmat = Matrix.CreateFromYawPitchRoll(Param.Rot.X,Param.Rot.Y,Param.Rot.Z) * inv * matScaleLast * Matrix.CreateTranslation(wp);
                }
                else
                {
                    drawmat = matLast;
                }

                basicEffect.World = drawmat;
                basicEffect.Projection = mng.Proj;

                basicEffect.Alpha = 1.0f;
                basicEffect.CommitChanges();


                GrfDevice.DrawUserPrimitives<VertexPositionColorTexture>(
                    PrimitiveType.TriangleStrip,
                    vertices,
                    0,
                    2
                );


                // パスの終了
                pass.End();
            }

            // エフェクトの使用を終了する
            basicEffect.End();
        }
    }
}
