﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using FrkEffectLib;

namespace FrkSample1
{
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        //エフェクトデータ
        FrkLibEffectData data;
        KeyboardState beforeKeyState = new KeyboardState();
        GamePadState beforePadState = new GamePadState();

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }
        protected override void Initialize()
        {
            //エフェクトマネージャー初期化
            FrkLibEffectManager.GetInstance().Init(Content, GraphicsDevice);
            //エフェクトデータ読み込み
            data = FrkLibEffectManager.GetInstance().LoadFrkData("Bom");
        }
        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);
        }

        protected override void UnloadContent()
        {
        }

        protected override void Update(GameTime gameTime)
        {
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed ||
                Keyboard.GetState().IsKeyDown(Keys.Escape))
                this.Exit();

            //ビュー行列の作成
            Matrix view;
            Vector3 campos = new Vector3(0, 0, 10);
            view = Matrix.CreateLookAt(campos, Vector3.Zero, Vector3.Up);

            //プロジェクション行列の作成
            Matrix proj;
            float aspectRatio;
            aspectRatio =
                (float)GraphicsDevice.Viewport.Width /
                (float)GraphicsDevice.Viewport.Height;

            proj = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver4,
                                        aspectRatio, 1.0f, 300.0f);

            //Zキーが押されたらエフェクト生成
            if ((Keyboard.GetState().IsKeyDown(Keys.Z)
                && !beforeKeyState.IsKeyDown(Keys.Z)) ||
                (GamePad.GetState(PlayerIndex.One).Buttons.A == ButtonState.Pressed
                && beforePadState.Buttons.A == ButtonState.Released))
            {
                FrkLibEffectManager.GetInstance().CreateEffect(data, Vector3.Zero, Vector3.One, Quaternion.Identity, Color.White);
            }

            beforeKeyState = Keyboard.GetState();
            beforePadState = GamePad.GetState(PlayerIndex.One);

            //エフェクトマネージャの更新
            FrkLibEffectManager.GetInstance().Update(ref view,ref proj);

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);
            
            //エフェクトマネージャの描画
            FrkLibEffectManager.GetInstance().Draw();
            base.Draw(gameTime);
        }
    }
}
