﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsGame1;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace FrkEffectViewer.GameSystem
{
    class Grid : GameObject3D
    {
        public override bool Main()
        {
            return false;
        }
        public override void Draw()
        {
            VertexPositionColorTexture[] vertices = new VertexPositionColorTexture[11*2*2];

            float s = 1.0f;
            Scale = new Vector3(s, s, s);

            for (int i = 0; i < 11; i++)
            {
                vertices[0 + i * 2].Position = new Vector3(-5 + i, 0, -5);
                vertices[0 + i * 2].Color = Color.Gray;
                vertices[1 + i * 2].Position = new Vector3(-5 + i, 0, 5);
                vertices[1 + i * 2].Color = Color.Gray;
            }
            for (int i = 0; i < 11; i++)
            {
                vertices[22 + i * 2].Position = new Vector3(-5, 0, -5 + i);
                vertices[22 + i * 2].Color = Color.Gray;
                vertices[23 + i * 2].Position = new Vector3(5, 0, -5 + i);
                vertices[23 + i * 2].Color = Color.Gray;
            } 


            // エフェクトの使用を開始します
            basicEffect.Begin();

            //基本的なポリラインの描画
            // 描画する頂点データの定義を設定
            GrfDevice.VertexDeclaration = GameManager.GetGameManager().vertexDeclaration;




            //アルファブレンドを有効にする
            GrfDevice.RenderState.AlphaBlendEnable = false;

            // パスの数だけ繰り替えし描画 (といっても BasicEffect は通常１回)
            for (int i = 0; i < basicEffect.CurrentTechnique.Passes.Count; i++)
            {
                EffectPass pass = basicEffect.CurrentTechnique.Passes[i];
                // パスの開始
                pass.Begin();

                //Zバッファを有効にする
                GrfDevice.RenderState.DepthBufferEnable = true;
                GrfDevice.RenderState.DepthBufferWriteEnable = false;

                basicEffect.TextureEnabled = false;
                basicEffect.Texture = null;

                basicEffect.LightingEnabled = false;
                basicEffect.VertexColorEnabled = true;

                // ポリゴンを描画する

                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.CullMode = CullMode.None;
                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.DepthBufferEnable = true;
                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.DepthBufferWriteEnable = false;
                Matrix CamMat = CamManager.GetCamManager().GetNowCamera().GetMatrix();

                // ビュー座標変換行列
                Matrix view = CamMat;

                // 射影変換行列
                Matrix projection = CamManager.GetCamManager().GetNowCamera().GetProj();

                basicEffect.View = view;
                basicEffect.World = Matrix.Identity;
                basicEffect.Projection = projection;

                basicEffect.CommitChanges();

                basicEffect.Alpha = 1.0f;

                GrfDevice.DrawUserPrimitives<VertexPositionColorTexture>(
                    PrimitiveType.LineList,
                    vertices,
                    0,
                    22
                );


                // パスの終了
                pass.End();
            }

            // エフェクトの使用を終了する
            basicEffect.End();
        }
    }
}
