/*
 * XNua 0.1 Based Massively on Lua2IL 0.5
 * Lua2IL 0.5.0
 * CheckType.cs - Lua/CLR/Lua conversions for the interface layer
 * Copyright 2003-2005 Fabio Mascarenhas
 * 
 */

using System;
using System.Collections;
using System.Collections.Generic;

namespace XNua
{

	delegate object ConvToCLR(ref LuaValue val);
	delegate LuaValue ConvFromCLR(object val);
	delegate void ConvToLua(LuaState L, int index, object val);

	class TypeChecker
	{
		static Dictionary<object,LuaReference> objects;

		static Dictionary<Type,ConvToCLR> toCLRConverters;
		static Dictionary<Type,ConvFromCLR> fromCLRConverters;
		static Dictionary<Type,ConvToLua> toLuaConverters;

		static TypeChecker() 
		{
            objects = new Dictionary<object, LuaReference>(256);// Hashtable.Synchronized(new Hashtable());
            toCLRConverters = new Dictionary<Type, ConvToCLR>(256);
            fromCLRConverters = new Dictionary<Type, ConvFromCLR>(256);
            toLuaConverters = new Dictionary<Type, ConvToLua>(256);

			toCLRConverters[typeof(sbyte)]=new ConvToCLR(TypeChecker.getAsSbyte);
			toCLRConverters[typeof(byte)]=new ConvToCLR(TypeChecker.getAsByte);
			toCLRConverters[typeof(short)]=new ConvToCLR(TypeChecker.getAsShort);
			toCLRConverters[typeof(ushort)]=new ConvToCLR(TypeChecker.getAsUshort);
			toCLRConverters[typeof(int)]=new ConvToCLR(TypeChecker.getAsInt);
			toCLRConverters[typeof(uint)]=new ConvToCLR(TypeChecker.getAsUint);
			toCLRConverters[typeof(long)]=new ConvToCLR(TypeChecker.getAsLong);
			toCLRConverters[typeof(ulong)]=new ConvToCLR(TypeChecker.getAsUlong);
			toCLRConverters[typeof(double)]=new ConvToCLR(TypeChecker.getAsDouble);
			toCLRConverters[typeof(char)]=new ConvToCLR(TypeChecker.getAsChar);
			toCLRConverters[typeof(float)]=new ConvToCLR(TypeChecker.getAsFloat);
			toCLRConverters[typeof(decimal)]=new ConvToCLR(TypeChecker.getAsDecimal);
			toCLRConverters[typeof(object)]=new ConvToCLR(TypeChecker.getAsObject);

			fromCLRConverters[typeof(sbyte)]=new ConvFromCLR(TypeChecker.getAsSbyte);
			fromCLRConverters[typeof(byte)]=new ConvFromCLR(TypeChecker.getAsByte);
			fromCLRConverters[typeof(short)]=new ConvFromCLR(TypeChecker.getAsShort);
			fromCLRConverters[typeof(ushort)]=new ConvFromCLR(TypeChecker.getAsUshort);
			fromCLRConverters[typeof(int)]=new ConvFromCLR(TypeChecker.getAsInt);
			fromCLRConverters[typeof(uint)]=new ConvFromCLR(TypeChecker.getAsUint);
			fromCLRConverters[typeof(long)]=new ConvFromCLR(TypeChecker.getAsLong);
			fromCLRConverters[typeof(ulong)]=new ConvFromCLR(TypeChecker.getAsUlong);
			fromCLRConverters[typeof(double)]=new ConvFromCLR(TypeChecker.getAsDouble);
			fromCLRConverters[typeof(char)]=new ConvFromCLR(TypeChecker.getAsChar);
			fromCLRConverters[typeof(float)]=new ConvFromCLR(TypeChecker.getAsFloat);
			fromCLRConverters[typeof(decimal)]=new ConvFromCLR(TypeChecker.getAsDecimal);
			fromCLRConverters[typeof(string)]=new ConvFromCLR(TypeChecker.getAsString);
			fromCLRConverters[typeof(bool)]=new ConvFromCLR(TypeChecker.getAsBoolean);
			fromCLRConverters[typeof(LuaValue)]=new ConvFromCLR(TypeChecker.getAsValue);
			fromCLRConverters[typeof(LuaReference)]=new ConvFromCLR(TypeChecker.getAsReference);
			fromCLRConverters[typeof(object)]=new ConvFromCLR(TypeChecker.getAsObject);

			toLuaConverters[typeof(sbyte)]=new ConvToLua(TypeChecker.setAsNumberFromSbyte);
			toLuaConverters[typeof(byte)]=new ConvToLua(TypeChecker.setAsNumberFromByte);
			toLuaConverters[typeof(short)]=new ConvToLua(TypeChecker.setAsNumberFromShort);
			toLuaConverters[typeof(ushort)]=new ConvToLua(TypeChecker.setAsNumberFromUshort);
			toLuaConverters[typeof(int)]=new ConvToLua(TypeChecker.setAsNumberFromInt);
			toLuaConverters[typeof(uint)]=new ConvToLua(TypeChecker.setAsNumberFromUint);
			toLuaConverters[typeof(long)]=new ConvToLua(TypeChecker.setAsNumberFromLong);
			toLuaConverters[typeof(ulong)]=new ConvToLua(TypeChecker.setAsNumberFromUlong);
			toLuaConverters[typeof(double)]=new ConvToLua(TypeChecker.setAsNumberFromDouble);
			toLuaConverters[typeof(char)]=new ConvToLua(TypeChecker.setAsNumberFromChar);
			toLuaConverters[typeof(float)]=new ConvToLua(TypeChecker.setAsNumberFromFloat);
			toLuaConverters[typeof(decimal)]=new ConvToLua(TypeChecker.setAsNumberFromDecimal);
			toLuaConverters[typeof(string)]=new ConvToLua(TypeChecker.setAsString);
			toLuaConverters[typeof(bool)]=new ConvToLua(TypeChecker.setAsBoolean);
			toLuaConverters[typeof(LuaValue)]=new ConvToLua(TypeChecker.setAsValue);
			toLuaConverters[typeof(LuaReference)]=new ConvToLua(TypeChecker.setAsReference);
			toLuaConverters[typeof(void)]=new ConvToLua(TypeChecker.setAsNothing);
			toLuaConverters[typeof(object)]=new ConvToLua(TypeChecker.setAsObject);
		}

		public static ConvToCLR GetToCLRConv(Type paramType) 
		{
			if(paramType.IsByRef) paramType=paramType.GetElementType();
            ConvToCLR converter;// = toCLRConverters[paramType];
            if (toCLRConverters.TryGetValue(paramType,out converter))
                return (ConvToCLR)converter;
            else
            {
#if LUA2IL_CANEMIT
                if (paramType.IsSubclassOf(typeof(Delegate)))
                    return new ConvToCLR(new DelegateGenerator(paramType).getGeneratedDelegate);
                else
#endif
                    return (ConvToCLR)toCLRConverters[typeof(object)];
            }
		}

		public static ConvToLua GetToLuaConv(Type paramType) 
		{
            ConvToLua converter;// = toLuaConverters[paramType];
			if(toLuaConverters.TryGetValue(paramType,out converter))
				return converter;
			else
				return toLuaConverters[typeof(object)];
		}

		public static ConvFromCLR GetFromCLRConv(Type paramType) 
		{
            ConvFromCLR converter;// = fromCLRConverters[paramType];
            if (fromCLRConverters.TryGetValue(paramType,out converter))
				return converter;
			else
				return fromCLRConverters[typeof(object)];
		}

		private static object getAsSbyte(ref LuaValue val) 
		{
			if(val.O==null)
				return (sbyte)val.N;
			else
				return null;
		}
		private static LuaValue getAsSbyte(object val) 
		{
			return new LuaValue((double)((sbyte)val));
		}
		private static object getAsByte(ref LuaValue val) 
		{
			if(val.O==null)
				return (byte)val.N;
			else
				return null;
		}
		private static LuaValue getAsByte(object val) 
		{
			return new LuaValue((double)((byte)val));
		}
		private static object getAsShort(ref LuaValue val) 
		{
			if(val.O==null)
				return (short)val.N;
			else
				return null;
		}
		private static LuaValue getAsShort(object val) 
		{
			return new LuaValue((double)((short)val));
		}
		private static object getAsUshort(ref LuaValue val) 
		{
			if(val.O==null)
				return (ushort)val.N;
			else
				return null;
		}
		private static LuaValue getAsUshort(object val) 
		{
			return new LuaValue((double)((ushort)val));
		}
		private static object getAsInt(ref LuaValue val) 
		{
			if(val.O==null)
				return (int)val.N;
			else
				return null;
		}
		private static LuaValue getAsInt(object val) 
		{
			return new LuaValue((double)((int)val));
		}
		private static object getAsUint(ref LuaValue val) 
		{
			if(val.O==null)
				return (uint)val.N;
			else
				return null;
		}
		private static LuaValue getAsUint(object val) 
		{
			return new LuaValue((double)((uint)val));
		}
		private static object getAsLong(ref LuaValue val) 
		{
			if(val.O==null)
				return (long)val.N;
			else
				return null;
		}
		private static LuaValue getAsLong(object val) 
		{
			return new LuaValue((double)((long)val));
		}
		private static object getAsUlong(ref LuaValue val) 
		{
			if(val.O==null)
				return (ulong)val.N;
			else
				return null;
		}
		private static LuaValue getAsUlong(object val) 
		{
			return new LuaValue((double)((ulong)val));
		}
		private static object getAsDouble(ref LuaValue val) 
		{
			if(val.O==null)
				return val.N;
			else
				return null;
		}
		private static LuaValue getAsDouble(object val) 
		{
			return new LuaValue((double)val);
		}
		private static object getAsChar(ref LuaValue val) 
		{
			if(val.O==null)
				return (char)val.N;
			else
				return null;
		}
		private static LuaValue getAsChar(object val) 
		{
			return new LuaValue((double)((char)val));
		}
		private static object getAsFloat(ref LuaValue val) 
		{
			if(val.O==null)
				return (float)val.N;
			else
				return null;
		}
		private static LuaValue getAsFloat(object val) 
		{
			return new LuaValue((double)((float)val));
		}
		private static object getAsDecimal(ref LuaValue val) 
		{
			if(val.O==null)
				return (decimal)val.N;
			else
				return null;
		}
		private static LuaValue getAsDecimal(object val) 
		{
			return new LuaValue((double)((decimal)val));
		}
		private static LuaValue getAsValue(object val) 
		{
			return (LuaValue)val;
		}
		private static LuaValue getAsReference(object val) 
		{
			LuaReference refr=(LuaReference)val;
			if(refr==null)
				refr=NilClass.Instance;
			return new LuaValue(refr);
		}
		private static LuaValue getAsString(object val) 
		{
			string sval=(string)val;
			if(sval!=null) 
			{
				LuaReference refr;//=(LuaReference)objects[val];
				if(!objects.TryGetValue(val,out refr)) 
				{
					refr=new LuaString(sval);
					objects[val]=refr;
				}
				return new LuaValue(refr);
			} 
			return new LuaValue(NilClass.Instance);
		}
		private static LuaValue getAsBoolean(object val) 
		{
			bool bval=(bool)val;
			if(bval)
				return new LuaValue(TrueClass.Instance);
			else
				return new LuaValue(FalseClass.Instance);
		}
		private static object getAsObject(ref LuaValue val) 
		{
			if(val.O==null)
				return val.N;
			else
				return val.O.CLRObject;
		}
		private static LuaValue getAsObject(object val) 
		{
			if(val!=null) 
			{
				LuaReference refr;//=(LuaReference)objects[val];
				if(!objects.TryGetValue(val,out refr)) 
				{
					refr=new LuaObjectWrapper(val);
					objects[val]=refr;
				}
				return new LuaValue(refr);
			} 
			return new LuaValue(NilClass.Instance);
		}

		private static void setAsNumberFromByte(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((byte)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromSbyte(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((sbyte)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromShort(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((short)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromUshort(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((ushort)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromInt(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((int)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromUint(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((uint)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromLong(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((long)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromUlong(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((ulong)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromDouble(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)val;
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromFloat(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((float)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromChar(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((char)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsNumberFromDecimal(LuaState L,int index,object val) 
		{
			L.Stack.Values[index].N=(double)((decimal)val);
			L.Stack.Values[index].O=null;
		}
		private static void setAsValue(LuaState L,int index,object val) 
		{
			LuaValue rval=(LuaValue)val;
			L.Stack.Values[index]=rval;
		}
		private static void setAsReference(LuaState L,int index,object val) 
		{
			LuaReference rval=(LuaReference)val;
			if(rval!=null) 
			{
				L.Stack.Values[index].O=rval;
			} 
			else 
			{
				L.Stack.Values[index].O=NilClass.Instance;
			}
		}
		private static void setAsString(LuaState L,int index,object val) 
		{
			string sval=(string)val;
			if(sval!=null) 
			{
				LuaReference refr;//=(LuaReference)objects[val];
				if(!objects.TryGetValue(val,out refr) )
				{
					refr=new LuaString(sval);
					objects[val]=refr;
				}
				L.Stack.Values[index].O=refr;
			} 
			else 
			{
				L.Stack.Values[index].O=NilClass.Instance;
			}
		}
		private static void setAsBoolean(LuaState L,int index,object val) 
		{
			bool bval=(bool)val;
			if(bval)
				L.Stack.Values[index].O=TrueClass.Instance;
			else
				L.Stack.Values[index].O=FalseClass.Instance;
		}
		private static void setAsNothing(LuaState L,int index,object val) 
		{
		}
		private static void setAsObject(LuaState L,int index,object val) 
		{
			if(val!=null) 
			{
				LuaReference refr;//=(LuaReference)objects[val];
				if(!objects.TryGetValue(val,out refr)) 
				{
					refr=new LuaObjectWrapper(val);
					objects[val]=refr;
				}
				L.Stack.Values[index].O=refr;
			} 
			else 
			{
				L.Stack.Values[index].O=NilClass.Instance;
			}
		}
	}
}
