/*
 * 
 * XNua 0.1 Based Massively on Lua2IL 0.5
 * Lua2IL 0.5.0
 * Opcodes.cs - Lua opcodes and related constants
 * Copyright 2003-2005 Fabio Mascarenhas
 *                2007 Dean Calver
 * 
 */

using System;

namespace XNua
{
	public struct OpSizes 
	{
		public static byte SIZE_C=9;
		public static byte SIZE_B=9;
		public static byte SIZE_Bx=(byte)(SIZE_C+SIZE_B);
		public static byte SIZE_A=8;

		public static byte SIZE_OP=6;

		public static byte POS_C=SIZE_OP;
		public static byte POS_B=(byte)(POS_C+SIZE_C);
		public static byte POS_Bx=POS_C;
		public static byte POS_A=(byte)(POS_B+SIZE_B);

		public static int MASK_OP=(~((~0)<<OpSizes.SIZE_OP));
		public static int MASK_B=(~((~0)<<OpSizes.SIZE_B));
		public static int MASK_C=(~((~0)<<OpSizes.SIZE_C));
		public static int MASK_Bx=(~((~0)<<OpSizes.SIZE_Bx));
	}

	public enum LuaOpCode
	{
		/*----------------------------------------------------------------------
		name            args    description
		------------------------------------------------------------------------*/
		OP_MOVE,/*      A B     R(A) := R(B)                                    */
		OP_LOADK,/*     A Bx    R(A) := Kst(Bx)                                 */
		OP_LOADBOOL,/*  A B C   R(A) := (Bool)B; if (C) PC++                    */
		OP_LOADNIL,/*   A B     R(A) := ... := R(B) := nil                      */
		OP_GETUPVAL,/*  A B     R(A) := UpValue[B]                              */

		OP_GETGLOBAL,/* A Bx    R(A) := Gbl[Kst(Bx)]                            */
		OP_GETTABLE,/*  A B C   R(A) := R(B)[RK(C)]                             */

		OP_SETGLOBAL,/* A Bx    Gbl[Kst(Bx)] := R(A)                            */
		OP_SETUPVAL,/*  A B     UpValue[B] := R(A)                              */
		OP_SETTABLE,/*  A B C   R(A)[RK(B)] := RK(C)                            */

		OP_NEWTABLE,/*  A B C   R(A) := {} (size = B,C)                         */

		OP_SELF,/*      A B C   R(A+1) := R(B); R(A) := R(B)[RK(C)]             */

		OP_ADD,/*       A B C   R(A) := RK(B) + RK(C)                           */
		OP_SUB,/*       A B C   R(A) := RK(B) - RK(C)                           */
		OP_MUL,/*       A B C   R(A) := RK(B) * RK(C)                           */
		OP_DIV,/*       A B C   R(A) := RK(B) / RK(C)                           */
		OP_POW,/*       A B C   R(A) := RK(B) ^ RK(C)                           */
		OP_UNM,/*       A B     R(A) := -R(B)                                   */
		OP_NOT,/*       A B     R(A) := not R(B)                                */

		OP_CONCAT,/*    A B C   R(A) := R(B).. ... ..R(C)                       */

		OP_JMP,/*       sBx     PC += sBx                                       */

		OP_EQ,/*        A B C   if ((RK(B) == RK(C)) ~= A) then pc++            */
		OP_LT,/*        A B C   if ((RK(B) <  RK(C)) ~= A) then pc++            */
		OP_LE,/*        A B C   if ((RK(B) <= RK(C)) ~= A) then pc++            */

		OP_TEST,/*      A B C   if (R(B) <=> C) then R(A) := R(B) else pc++     */ 

		OP_CALL,/*      A B C   R(A), ... ,R(A+C-2) := R(A)(R(A+1), ... ,R(A+B-1)) */
		OP_TAILCALL,/*  A B C   return R(A)(R(A+1), ... ,R(A+B-1))              */
		OP_RETURN,/*    A B     return R(A), ... ,R(A+B-2)      (see note)      */

		OP_FORLOOP,/*   A sBx   R(A)+=R(A+2); if R(A) <?= R(A+1) then PC+= sBx  */

		OP_TFORLOOP,/*  A C     R(A+2), ... ,R(A+2+C) := R(A)(R(A+1), R(A+2)); 
                        if R(A+2) ~= nil then pc++                      */
		OP_TFORPREP,/*  A sBx   if type(R(A)) == table then R(A+1):=R(A), R(A):=next;
                        PC += sBx                                       */

		OP_SETLIST,/*   A Bx    R(A)[Bx-Bx%FPF+i] := R(A+i), 1 <= i <= Bx%FPF+1 */
		OP_SETLISTO,/*  A Bx                                                    */

		OP_CLOSE,/*     A       close all variables in the stack up to (>=) R(A)*/
		OP_CLOSURE/*    A Bx    R(A) := closure(KPROTO[Bx], R(A), ... ,R(A+n))  */
	}
}