// XNuaContentImporter.h

#pragma once

using namespace System;
using namespace System::IO;
using namespace Microsoft::Xna::Framework;
using namespace System::Runtime::InteropServices;
using namespace Microsoft::Xna::Framework::Content::Pipeline;
using namespace Microsoft::Xna::Framework::Content::Pipeline::Serialization::Compiler;
using namespace XNua::LuaParser;
using namespace System::Xml;
#include <gcroot.h>





namespace XNuaILContentImporter {

	public ref class XNuaIntermediate
	{
	public:
		XNuaIntermediate( MemoryStream^ ms, String^ filename, Parser^ parser ) 
			: m_LuaStream( ms ), m_Filename( filename ), m_Parser( parser )
		{
		}
		MemoryStream^	m_LuaStream;
		String^			m_Filename;
		Parser^			m_Parser;
	};
#if 0
    public ref class CompiledXNua
    {
	public:
		CompiledXNua(String^ filename)
        {
			m_Filename = filename;
        }

        String^ m_Filename;

    };
#endif
#if 0
	[ContentTypeWriter]
    public ref class XNuaWriter : ContentTypeWriter<String^>
    {
	public:
		virtual String ^GetRuntimeReader(Microsoft::Xna::Framework::TargetPlatform targetPlatform) override
		{
            return "XNua.XNuaContentTypeReader, XNua";
		}
		/*virtual String^ GetRuntimeType(Microsoft::Xna::Framework::TargetPlatform targetPlatform) override
        {
			return Type::GetType("CompiledXNua")->AssemblyQualifiedName;
        }*/
        
	protected:
		virtual void Write(ContentWriter^ output, String^ value) override 
        {
            output->Write(value);
        }
	};
#endif

	[ContentImporter(".lua", DefaultProcessor = "XNuaProcessor", DisplayName="Lua Importer")]
	public ref class XNuaContentImport : ContentImporter< XNuaIntermediate^ >
	{
	public: 

		virtual XNuaIntermediate^ Import( String^ filename, ContentImporterContext^ context) override
		{
//			Diagnostics::Debugger::Launch();

			// we want to keep as much in memory so we use some memory streams
			// to communicate between the different phases of the process
			try
			{
				Parser^ parser = gcnew Parser();
				// parse the file
				ProtoWrapper^ proto = parser->ParseFile(filename);
				// assume the the binary lua file will never get more than 10MB in size
				MemoryStream^ memstream = gcnew MemoryStream(10 * 1024 * 1024);
				parser->WriteByteCode( proto, memstream );

				// okay pass the in memory byte code version of the file back to XNA Content pipeline
				// where it will get processed into IL code on disk
				return gcnew XNuaIntermediate(memstream, Path::GetFileNameWithoutExtension(filename), parser );
			} catch( ParseException^ e )
			{
				// convert into a content exception so parse errors get source level intergation
				// with VS Express
				ContentIdentity^ ci = gcnew ContentIdentity(e->Source, "XNuaContentImportor", e->LineNum );
				throw gcnew InvalidContentException(e->MessageText, ci);
			}
		}
	};

    [ContentProcessor(DisplayName="XNuaProcessor")]
    public ref class XNuaProcessor : ContentProcessor<XNuaIntermediate^,String^ >
    {
	public:
		virtual String^ Process(XNuaIntermediate^ input, ContentProcessorContext^ context) override 
        {
//			Diagnostics::Debugger::Launch();
			input->m_LuaStream->Seek(0,SeekOrigin::Begin);

			// there seems to be no way of working out the output path at the mo!!
			// so you have two choices, 1) Assume where every the content importer is
			// is the right path or try and guess based on configuration info
			// I default to the second for now but this will break if you have any
			// non standard path setup
			String^ path = nullptr;
#if 0
			// i believe this is fixed in XNA 2.0 but until then I've added a simple
			// xml config file that can be used to config the output directory
			String^ asmpath = Path::GetDirectoryName(Reflection::Assembly::GetExecutingAssembly()->Location);
			String^ xmlpath = Path::Combine(asmpath,"XnuaContentImporter.xml");
			if( File::Exists( xmlpath ) )
			{
                XmlDocument^ doc = gcnew XmlDocument();
                doc->Load(xmlpath);
				XmlNode^ useCustomNode = doc->DocumentElement->SelectSingleNode("UseCustomPath");
				if( useCustomNode != nullptr && useCustomNode->FirstChild->Value == "true")
				{
					XmlNode^ customNode = doc->DocumentElement->SelectSingleNode("CustomPath");
					if( customNode != nullptr)
					{
						path = Path::Combine( asmpath, customNode->FirstChild->Value );
					}
				}
			}

			if( path == nullptr)
			{
#if defined(USE_ASSEMBLY_PATH)
				path = Reflection::Assembly::GetExecutingAssembly()->Location;
				path = Path::GetDirectoryName(path) + "\\";
#else
				// orginal c# code from Shawn Hargreaves
				path = gcnew String("bin/");

				if (context->TargetPlatform == TargetPlatform::Windows)
				   path += "x86/";
				else
				   path += "Xbox 360/";

				path += context->BuildConfiguration;
#endif#
			}
			if( Directory::Exists(path) == false )
			{
				Directory::CreateDirectory(path);
			}
			path += "/" + input->m_Filename + ".lil";
#endif
			
            path=Path::Combine(Path::GetDirectoryName(context->OutputFilename), Path::GetFileNameWithoutExtension( context->OutputFilename));
            path+=".lil";
            if( Directory::Exists(Path::GetDirectoryName(context->OutputFilename)) == false )
            {
                Directory::CreateDirectory(Path::GetDirectoryName(context->OutputFilename));
            }
            input->m_Parser->ByteCodeToIL( input->m_LuaStream, path );

            
#if 0
            //read .lil asssembly and pass to pipeline
            System::IO::FileStream^ stream=gcnew System::IO::FileStream(path,System::IO::FileMode::Open);
            array<System::Byte>^ data=gcnew array<System::Byte>((int)stream->Length);
            stream->Read(data,0,data->Length);
            stream->Close();
#endif       
			return path;
            
        }
    };
}
