﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsGame1;
using Microsoft.Xna.Framework;

namespace FrkEffectViewer.GameSystem
{
    class Camera
    {
        private Vector3 Pos;
        private Quaternion Qua;
        private Matrix Mat;
        private Matrix Proj;
        private Vector3 Tgt;
        private Vector3 Up;
        public int nNo;

        public Camera( Vector3 pos, Matrix mat,int no)
        {
            nNo = no;
            Mat = mat;
            Pos = pos;
            
            float aspectRatio;
            aspectRatio =
                (float)GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.Viewport.Width /
                (float)GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.Viewport.Height;

            Proj = Matrix.CreatePerspectiveFieldOfView(MathHelper.PiOver4,
                                        aspectRatio, 1.0f, 300.0f);

        }

        public void SetPos(Vector3 pos)
        {
            Mat.Translation = pos;
            Pos = pos;
        }
        public void SetLook(Vector3 tgt,Vector3 up)
        {
            Tgt = tgt;
            Up = up;
            Mat = Matrix.CreateLookAt(Pos, tgt, up);
        }
        public void SetUp(Vector3 up)
        {
            Mat.Up = up;
            Up = up;
        }
        public void SetMat(Matrix mat)
        {
            Mat = mat;
            Pos = Mat.Translation;
        }
        public void SetProj(Matrix proj)
        {
            Proj = proj;
        }
        public void SetQuaternion(Quaternion q)
        {
            Qua = q;
            Mat = Matrix.CreateFromQuaternion(q);
        }

        public Matrix GetMatrix()
        {
            Mat = Matrix.CreateLookAt(Pos, Tgt, Up);
            return Mat;
        }
        public Vector3 GetPos()
        {
            return Pos;
        }
        public Vector3 GetTgt()
        {
            return Tgt;
        }
        public Vector3 GetUp()
        {
            return Up;
        }
        public Matrix GetProj()
        {
            return Proj;
        }
    }
}
