﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FrkEffectViewer.GameSystem;

namespace WindowsGame1
{
    class ObjectManager
    {
        public enum OBJLISTTYPE
        {
            OBJLIST_NORMAL,
            OBJLIST_ALPHA,
            OBJLIST_ADD,
            OBJLIST_MAX,
        };

        private ObjectManager()
        {
            //初期化処理
            for (int i = 0; i < (int)OBJLISTTYPE.OBJLIST_MAX; i++)
            {
                ObjList[i] = new LinkedList<ObjectBase>();
                ObjList[i].Clear();
            }
        }

        private LinkedList<ObjectBase>[] ObjList = new LinkedList<ObjectBase>[(int)OBJLISTTYPE.OBJLIST_MAX];

        private static ObjectManager pManager;
        public static ObjectManager GetObjectManager()
        {
            if (pManager == null)
            {
                pManager = new ObjectManager();
            }

            return pManager;
        }
        public void Main()
        {
            for (int i = 0; i < (int)OBJLISTTYPE.OBJLIST_MAX; i++)
            {
                LinkedListNode<ObjectBase> lln = ObjList[i].First;
                //何も入ってなかったら終了
                if (lln == null)
                    continue;
                while (lln != null)
                {
                    //メイン処理実行
                    if (lln.Value.Main())
                    {
                        //消滅時trueが帰ってくる

                        LinkedListNode<ObjectBase> buf = lln.Next;
                        ObjList[i].Remove(lln.Value);
                        lln = buf;
                    }
                    else
                    {
                        lln = lln.Next;
                    }
                }
            }

        }
        public void Draw()
        {
            //描画初期化処理

            for (int i = 0; i < (int)OBJLISTTYPE.OBJLIST_MAX; i++)
            {
                foreach (ObjectBase Obj in ObjList[i])
                {
                    {
                        //描画処理
                        Obj.Draw();
                    }
                }
            }
        }
        //オブジェクト挿入処理
        public bool SetObject(ObjectBase p,OBJLISTTYPE n)
        {
            ObjList[(int)n].AddLast(p);
            return true;
        }


        private bool GetObjectDel(ObjectBase obj)
        {
            return obj.GetDelFlg();
        }
    }
}
