# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#


class FlowObject(object):
    DEFAULT_TYPE = 1

    def __init__(self, label, type=DEFAULT_TYPE, metadata={}):
        self.label = label
        self.type = type
        self.metadata = metadata

    def set_label(self, label):
        self.label = label

    def get_label(self):
        return self.label

    def set_type(self, type):
        self.type = type

    def get_type(self):
        return self.type

    def set_metadata(self, metadata):
        self.metadata = metadata

    def get_metadata(self):
        return self.metadata

    def __str__(self):
        return self.label

    def __repr__(self):
        return "{\"label\":\"" + self.label + \
            "\",\"type\":\"" + repr(self.type) + \
            "\",\"meta\":" + self._blank_dict(self.metadata) + "}"

    def _blank_dict(self, dict_object):
        if len(dict_object) > 0:
            return self._dict_to_json(dict_object)
        else:
            return "\"\""

    def _dict_to_json(self, dict_object):
        json_strings = "{"
        for dict_key in dict_object.keys():
            json_strings += "\"" + dict_key + \
                "\":\"" + dict_object[dict_key] + "\","
        json_strings = json_strings.rstrip(",") + "}"
        return json_strings

    def __add__(self, label):
        return self.label + label
