# vim: tabstop=4 shiftwidth=4 softtabstop=4
# -*- coding: utf-8 -*-
#
from __future__ import print_function
import sys


class CommonUtils():

    def __init__(self, opts=None):
        self._opts = opts
        self._tmp_stack = []

    def set_opts(self, opts):
        self._opts = opts

    def d_push(self, x):
        self._tmp_stack.append(x)
        return x

    def d_pop(self):
        return self._tmp_stack.pop()

    def verbose_out(self, msg):
        if hasattr(self, '_opts') and self._opts.verbose is True:
            print("[verbose]: " + msg, file=sys.stderr)

    def debug_out(self, msg):
        if hasattr(self, '_opts') and self._opts.debug is True:
            print("[debug]: " + msg, file=sys.stderr)

    def warn_out(self, msg):
        print("[warn]: " + msg, file=sys.stderr)

    def error_out(self, msg):
        print("[error]: " + msg, file=sys.stderr)

    def message_out(self, msg):
        print(msg)

    def to_bool(self, value):
        """
           Converts 'something' to boolean. Raises exception for invalid formats
               Possible True  values: 1, True, "1", "TRue", "yes", "y", "t"
               Possible False values: 0, False, None, [], {}, "", "0", "faLse", "no", "n", "f", 0.0, ...
        """
        if str(value).lower() in ("yes", "y", "true",  "t", "1"):
            return True
        if str(value).lower() in ("no",  "n", "false", "f", "0", "0.0", "", "none", "[]", "{}"):
            return False
        raise Exception('Invalid value for boolean conversion: ' + str(value))
