package jp.ne.motoki.android.fuelchecker;

import java.text.DateFormat;
import java.util.Calendar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.DatePicker;

public class DatePickerDialogPreference
        extends ValueDisplayableDialogPreference<DatePicker> {
    
    private static final DateFormat FORMATTER =
        DateFormat.getDateInstance(DateFormat.MEDIUM);
    
    private final Calendar CALENDAR = Calendar.getInstance();
    
    private OnDateChangedListener listener = null;

    public DatePickerDialogPreference(Context context, AttributeSet attrs) {
        super(context, attrs, new DatePicker(context));
    }

    public DatePickerDialogPreference(
            Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, new DatePicker(context));
    }
    
    public void setOnDateChangedListener(OnDateChangedListener listener) {
        this.listener = listener;
    }
    
    public int[] getDate() {
        int result[] = new int[] {
                CALENDAR.get(Calendar.YEAR),
                CALENDAR.get(Calendar.MONTH),
                CALENDAR.get(Calendar.DAY_OF_MONTH)
        };
        return result;
    }

    @Override
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
    }
    
    @Override
    protected void onDialogOk(DatePicker picker) {
        int year = picker.getYear();
        int monthOfYear = picker.getMonth();
        int dayOfMonth = picker.getDayOfMonth();
        CALENDAR.set(year, monthOfYear, dayOfMonth);
        
        if (listener != null) {
            listener.onDateChanged(year, monthOfYear, dayOfMonth);
        }
    }
    
    @Override
    protected String getDisplayText() {
        return FORMATTER.format(CALENDAR.getTime());
    }
    
    public static interface OnDateChangedListener {
        void onDateChanged(int year, int monthOfYear, int dayOfMonth);
    }
}
