package jp.ne.motoki.android.fuelchecker;

import jp.ne.motoki.android.picker.NumberPicker;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.FrameLayout;


public class NumericPicker extends FrameLayout {
    
    private static final int MAX_INTEGRAL_VALUE = 999;
    private static final int MIN_INTEGRAL_VALUE = 0;
    private static final int MAX_DECIMAL_VALUE = 9;
    private static final int MIN_DECIMAL_VALUE = 0;
    
    private final NumberPicker INTEGRAL_PART;
    private final NumberPicker DECIMAL_PART;

    public NumericPicker(Context context) {
        this(context, null);
    }

    public NumericPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NumericPicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater factory = LayoutInflater.from(getContext());
        factory.inflate(R.layout.number_picker_dialog, this,true);
        
        INTEGRAL_PART = (NumberPicker) findViewById(R.id.integral_part);
        INTEGRAL_PART.setRange(MIN_INTEGRAL_VALUE, MAX_INTEGRAL_VALUE);
        INTEGRAL_PART.setCurrent(MIN_INTEGRAL_VALUE);
        
        DECIMAL_PART = (NumberPicker) findViewById(R.id.decimal_part);
        DECIMAL_PART.setRange(MIN_DECIMAL_VALUE, MAX_DECIMAL_VALUE);
        DECIMAL_PART.setCurrent(MIN_DECIMAL_VALUE);
    }

    public int getIntegral() {
        return INTEGRAL_PART.getCurrent();
    }

    public int getDecimal() {
        return DECIMAL_PART.getCurrent();
    }

}
