package jp.ne.motoki.android.fuelchecker;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;

public class NumericPickerDialogPreference
        extends ValueDisplayableDialogPreference<NumericPicker> {
    
    private final String FORMAT;
    
    private int integralValue = 0;
    private int decimalValue = 0;
    
    private OnNumericChangedListener listener = null;

    public NumericPickerDialogPreference(Context context, AttributeSet attrs) {
        super(context, attrs, new NumericPicker(context));
        
        TypedArray a = context.obtainStyledAttributes(
                attrs, R.styleable.NumericPickerDialogPreference);
        String unit = a.getString(
                R.styleable.NumericPickerDialogPreference_unit);
        FORMAT = "%d.%d" + (unit == null ? "" : unit);
        
        // TODO
/*        IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_LOCALE_CHANGED);
        context.registerReceiver(new BroadcastReceiver() {

            @Override
            public void onReceive(Context context, Intent intent) {
                Log.d("test", intent.getAction());
                
                Bundle extras = intent.getExtras();
                if (extras != null) {
                    for (String key : extras.keySet()) {
                        Log.d("test", key + " = " + extras.get(key));
                    }
                } else {
                    Log.d("test", "extras is null");
                }
            }
            
        }, filter);*/
    }

    public NumericPickerDialogPreference(
            Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle, new NumericPicker(context));

        TypedArray a = context.obtainStyledAttributes(
                attrs, R.styleable.NumericPickerDialogPreference, defStyle, 0);
        String unit = a.getString(
                R.styleable.NumericPickerDialogPreference_unit);
        FORMAT = "%d.%d" + (unit == null ? "" : unit);
    }
    
    public void setOnNumericChangedListener(
            OnNumericChangedListener listener) {
        this.listener = listener;
    }
    
    public int[] getNumeric() {
        return new int[] {integralValue, decimalValue};
    }

    @Override
    protected String getDisplayText() {
        return String.format(FORMAT, integralValue, decimalValue);
    }

    @Override
    protected void onBindDialogView(View view) {
        super.onBindDialogView(view);
    }

    @Override
    protected void onDialogOk(NumericPicker picker) {
        integralValue = picker.getIntegral();
        decimalValue = picker.getDecimal();
        
        if (listener != null) {
            listener.onNumericChanged(integralValue, decimalValue);
        }
    }

    public static interface OnNumericChangedListener {
        void onNumericChanged(int integralValue, int decimalValue);
    }
}
