﻿using System;
using System.Linq;
using System.Text.RegularExpressions;
using System.Xml.Linq;

namespace Azyobuzi.HatenaDiaryClient.Models.Hatena
{
    public class BlogEntry
    {
        public DateTime Edited { set; get; }
        public string BlogPageUri { set; get; }
        public string Title { set; get; }
        public string Html { set; get; }
        public string HatenaSyntax { set; get; }
        public string DateId { set; get; }

        public BlogEntry() { }
        public BlogEntry(XElement xml)
        {
            this.Edited = DateTime.Parse(xml.Element(XmlNamespaces.AtomPub + "edited").Value);
            this.BlogPageUri = xml.Elements(XmlNamespaces.Atom + "link")
                .Where(_ => _.Attribute("rel").Value == "alternate")
                .Select(_ => _.Attribute("href").Value)
                .FirstOrDefault();
            this.Title = xml.Element(XmlNamespaces.Atom + "title").Value;
            this.Html = xml.Element(XmlNamespaces.Atom + "content").Value;
            this.HatenaSyntax = xml.Elements(XmlNamespaces.HatenaNs + "syntax")
                .Select(_ => _.Value)
                .SingleOrDefault();
            this.DateId = Regex.Match(
                xml.Elements(XmlNamespaces.Atom + "link")
                    .Where(_ => _.Attribute("rel").Value == "edit")
                    .Select(_ => _.Attribute("href").Value)
                    .First(),
                @"(\d+/\d+|\d+)$"
            ).ToString();
        }
    }
}
