﻿using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace Azyobuzi.HatenaDiaryClient.Models.Hatena
{
    public class HatenaDiary
    {
        public string UserName { set; get; }
        public string Password { set; get; }

        public Tuple<string, IEnumerable<BlogEntry>> GetEntrys(int page = 1)
        {
            var xdoc = WsseAtomConnection.Get(
                string.Format("http://d.hatena.ne.jp/{0}/atom/blog?page={1}", this.UserName, page),
                Encoding.UTF8,
                this.UserName,
                this.Password);
            var title = xdoc.Root.Element(XmlNamespaces.Atom + "title").Value;
            var entrys = xdoc.Root.Elements(XmlNamespaces.Atom + "entry").Select(_ => new BlogEntry(_));
            return Tuple.Create(title, entrys);
        }

        private static XDocument CreatePostEntryXml(string title, string content, DateTime? updated)
        {
            var elm = new XElement(XmlNamespaces.Atom02Spec + "entry",
                new XElement(XmlNamespaces.Atom02Spec + "title", title),
                new XElement(XmlNamespaces.Atom02Spec + "content", new XAttribute("type", "text/plain"), content));
            if (updated.HasValue)
                elm.Add(new XElement(XmlNamespaces.Atom02Spec + "updated", updated.Value.ToString("o")));
            return new XDocument(elm);
        }

        public BlogEntry PostEntry(string title, string content, DateTime? updated = null)
        {
            var reXml = WsseAtomConnection.Post(
                string.Format("http://d.hatena.ne.jp/{0}/atom/blog", this.UserName),
                CreatePostEntryXml(title, content, updated),
                Encoding.UTF8,
                this.UserName,
                this.Password);
            return new BlogEntry(reXml.Root)
            {
                HatenaSyntax = content
            };
        }

        public BlogEntry GetEntry(string dateId)
        {
            var xdoc = WsseAtomConnection.Get(
                string.Format("http://d.hatena.ne.jp/{0}/atom/blog/{1}", this.UserName, dateId),
                Encoding.UTF8,
                this.UserName,
                this.Password);
            return new BlogEntry(xdoc.Root);
        }

        public BlogEntry EditEntry(string dateId, string title, string content, DateTime? updated = null)
        {
            var reXml = WsseAtomConnection.Put(
                string.Format("http://d.hatena.ne.jp/{0}/atom/blog/{1}", this.UserName, dateId),
                CreatePostEntryXml(title, content, updated),
                Encoding.UTF8,
                this.UserName,
                this.Password);
            return new BlogEntry(reXml.Root)
            {
                HatenaSyntax = content
            };
        }

        public void DeleteEntry(string dateId)
        {
            WsseAtomConnection.Delete(
                string.Format("http://d.hatena.ne.jp/{0}/atom/blog/{1}", this.UserName, dateId),
                this.UserName,
                this.Password);
        }

        public Tuple<string, IEnumerable<BlogEntry>> GetDrafts(int page = 1)
        {
            var xdoc = WsseAtomConnection.Get(
                string.Format("http://d.hatena.ne.jp/{0}/atom/draft?page={1}", this.UserName, page),
                Encoding.UTF8,
                this.UserName,
                this.Password);
            var title = xdoc.Root.Element(XmlNamespaces.Atom + "title").Value;
            var entrys = xdoc.Root.Elements(XmlNamespaces.Atom + "entry").Select(_ => new BlogEntry(_));
            return Tuple.Create(title, entrys);
        }
        
        public BlogEntry PostDraft(string title, string content, DateTime? updated = null)
        {
            var reXml = WsseAtomConnection.Post(
                string.Format("http://d.hatena.ne.jp/{0}/atom/draft", this.UserName),
                CreatePostEntryXml(title, content, updated),
                Encoding.UTF8,
                this.UserName,
                this.Password);
            return new BlogEntry(reXml.Root)
            {
                HatenaSyntax = content
            };
        }

        public BlogEntry GetDraft(string id)
        {
            var xdoc = WsseAtomConnection.Get(
                string.Format("http://d.hatena.ne.jp/{0}/atom/draft/{1}", this.UserName, id),
                Encoding.UTF8,
                this.UserName,
                this.Password);
            return new BlogEntry(xdoc.Root);
        }

        public BlogEntry EditDraft(string id, string title, string content, DateTime? updated = null)
        {
            var reXml = WsseAtomConnection.Put(
                string.Format("http://d.hatena.ne.jp/{0}/atom/draft/{1}", this.UserName, id),
                CreatePostEntryXml(title, content, updated),
                Encoding.UTF8,
                this.UserName,
                this.Password);
            return new BlogEntry(reXml.Root)
            {
                HatenaSyntax = content
            };
        }

        public void DeleteDraft(string id)
        {
            WsseAtomConnection.Delete(
                string.Format("http://d.hatena.ne.jp/{0}/atom/draft/{1}", this.UserName, id),
                this.UserName,
                this.Password);
        }

        public BlogEntry PublishDraft(string id)
        {
            return new BlogEntry(
                XElement.Parse(
                    WsseAtomConnection.Put(
                        string.Format(
                            "http://d.hatena.ne.jp/{0}/atom/draft/{1}",
                            this.UserName,
                            id),
                        new NameValueCollection() { { "X-HATENA-PUBLISH", "1" } },
                        null,
                        Encoding.UTF8,
                        this.UserName,
                        this.Password)
                )
            );
        }
    }
}
